/*
 * Castaway
 *  (C) 1994 - 2002 Martin Doering, Joachim Hoenig
 *
 * $File$ - 68k move instructions
 *
 * This file is distributed under the GPL, version 2 or at your
 * option any later version.  See doc/license.txt for details.
 *
 * revision history
 *  23.05.2002  FAST1.0.1 code import: KR -> ANSI, restructuring
 *  30.10.2002  JH  Replaced "% 8" with "& 7". Helps lesser compilers to generate faster code.
 */
#ifndef PROTOH
static char     sccsid[] = "$Id: op68kmove.c,v 1.2 2002/10/30 16:23:06 jhoenig Exp $";
#include "68000.h"
#include "op68k.h"

#define DoMoveB(target,source) target = source; ClrCVSetNZ(target);
#define DoMoveW(target,source) target = source; ClrCVSetNZ(target);
#define DoMoveL(target,source) target = source; ClrCVSetNZ(target);

#define DoMovea(target,source) target = source;

#endif

Oper (Op1000, DoMoveB, DB, SdB, (inst & 7), DB, DR, Cd, 0, GN, SRB)
Oper (Op1010, DoMoveB, DB, SainB, (inst & 7), DB, DR, Cd, 0, GN, SRB)
Oper (Op1018, DoMoveB, DB, SaipB, (inst & 7), DB, DR, Cd, 0, GN, SRB)
Oper (Op1020, DoMoveB, DB, SmaiB, (inst & 7), DB, DR, Cd, 0, GN, SRB)
Oper (Op1028, DoMoveB, DB, SdaiB, (inst & 7), DB, DR, Cd, 0, GN, SRB)
Oper (Op1030, DoMoveB, DB, SaixB, (inst & 7), DB, DR, Cd, 0, GN, SRB)
Oper (Op1038, DoMoveB, DB, SearB, (inst & 7), DB, DR, Cd, 0, GN, SRB)
Oper (Op1080, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cain, 0, GN, SMB)
Oper (Op1090, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cain, 0, GN, SMB)
Oper (Op1098, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cain, 0, GN, SMB)
Oper (Op10a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cain, 0, GN, SMB)
Oper (Op10a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cain, 0, GN, SMB)
Oper (Op10b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cain, 0, GN, SMB)
Oper (Op10b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cain, 0, GN, SMB)
Oper (Op10c0, DoMoveB, DB, SdB, (inst & 7), DB, DA, CaipB, 0, GN, SMB)
Oper (Op10d0, DoMoveB, DB, SainB, (inst & 7), DB, DA, CaipB, 0, GN, SMB)
Oper (Op10d8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CaipB, 0, GN, SMB)
Oper (Op10e0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CaipB, 0, GN, SMB)
Oper (Op10e8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CaipB, 0, GN, SMB)
Oper (Op10f0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CaipB, 0, GN, SMB)
Oper (Op10f8, DoMoveB, DB, SearB, (inst & 7), DB, DA, CaipB, 0, GN, SMB)
Oper (Op1100, DoMoveB, DB, SdB, (inst & 7), DB, DA, CmaiB, 0, GN, SMB)
Oper (Op1110, DoMoveB, DB, SainB, (inst & 7), DB, DA, CmaiB, 0, GN, SMB)
Oper (Op1118, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CmaiB, 0, GN, SMB)
Oper (Op1120, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 0, GN, SMB)
Oper (Op1128, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CmaiB, 0, GN, SMB)
Oper (Op1130, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CmaiB, 0, GN, SMB)
Oper (Op1138, DoMoveB, DB, SearB, (inst & 7), DB, DA, CmaiB, 0, GN, SMB)
Oper (Op1140, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cdai, 0, GN, SMB)
Oper (Op1150, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cdai, 0, GN, SMB)
Oper (Op1158, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cdai, 0, GN, SMB)
Oper (Op1160, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cdai, 0, GN, SMB)
Oper (Op1168, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cdai, 0, GN, SMB)
Oper (Op1170, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cdai, 0, GN, SMB)
Oper (Op1178, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cdai, 0, GN, SMB)
Oper (Op1180, DoMoveB, DB, SdB, (inst & 7), DB, DA, Caix, 0, GN, SMB)
Oper (Op1190, DoMoveB, DB, SainB, (inst & 7), DB, DA, Caix, 0, GN, SMB)
Oper (Op1198, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Caix, 0, GN, SMB)
Oper (Op11a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Caix, 0, GN, SMB)
Oper (Op11a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Caix, 0, GN, SMB)
Oper (Op11b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Caix, 0, GN, SMB)
Oper (Op11b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Caix, 0, GN, SMB)
Oper (Op11c0, DoMoveB, DB, SdB, (inst & 7), DB, DA, Ceaw, 0, GN, SMB)
Oper (Op11d0, DoMoveB, DB, SainB, (inst & 7), DB, DA, Ceaw, 0, GN, SMB)
Oper (Op11d8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Ceaw, 0, GN, SMB)
Oper (Op11e0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Ceaw, 0, GN, SMB)
Oper (Op11e8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Ceaw, 0, GN, SMB)
Oper (Op11f0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Ceaw, 0, GN, SMB)
Oper (Op11f8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Ceaw, 0, GN, SMB)

Oper (Op1200, DoMoveB, DB, SdB, (inst & 7), DB, DR, Cd, 1, GN, SRB)
Oper (Op1210, DoMoveB, DB, SainB, (inst & 7), DB, DR, Cd, 1, GN, SRB)
Oper (Op1218, DoMoveB, DB, SaipB, (inst & 7), DB, DR, Cd, 1, GN, SRB)
Oper (Op1220, DoMoveB, DB, SmaiB, (inst & 7), DB, DR, Cd, 1, GN, SRB)
Oper (Op1228, DoMoveB, DB, SdaiB, (inst & 7), DB, DR, Cd, 1, GN, SRB)
Oper (Op1230, DoMoveB, DB, SaixB, (inst & 7), DB, DR, Cd, 1, GN, SRB)
Oper (Op1238, DoMoveB, DB, SearB, (inst & 7), DB, DR, Cd, 1, GN, SRB)
Oper (Op1280, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cain, 1, GN, SMB)
Oper (Op1290, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cain, 1, GN, SMB)
Oper (Op1298, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cain, 1, GN, SMB)
Oper (Op12a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cain, 1, GN, SMB)
Oper (Op12a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cain, 1, GN, SMB)
Oper (Op12b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cain, 1, GN, SMB)
Oper (Op12b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cain, 1, GN, SMB)
Oper (Op12c0, DoMoveB, DB, SdB, (inst & 7), DB, DA, CaipB, 1, GN, SMB)
Oper (Op12d0, DoMoveB, DB, SainB, (inst & 7), DB, DA, CaipB, 1, GN, SMB)
Oper (Op12d8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CaipB, 1, GN, SMB)
Oper (Op12e0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CaipB, 1, GN, SMB)
Oper (Op12e8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CaipB, 1, GN, SMB)
Oper (Op12f0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CaipB, 1, GN, SMB)
Oper (Op12f8, DoMoveB, DB, SearB, (inst & 7), DB, DA, CaipB, 1, GN, SMB)
Oper (Op1300, DoMoveB, DB, SdB, (inst & 7), DB, DA, CmaiB, 1, GN, SMB)
Oper (Op1310, DoMoveB, DB, SainB, (inst & 7), DB, DA, CmaiB, 1, GN, SMB)
Oper (Op1318, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CmaiB, 1, GN, SMB)
Oper (Op1320, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 1, GN, SMB)
Oper (Op1328, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CmaiB, 1, GN, SMB)
Oper (Op1330, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CmaiB, 1, GN, SMB)
Oper (Op1338, DoMoveB, DB, SearB, (inst & 7), DB, DA, CmaiB, 1, GN, SMB)
Oper (Op1340, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cdai, 1, GN, SMB)
Oper (Op1350, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cdai, 1, GN, SMB)
Oper (Op1358, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cdai, 1, GN, SMB)
Oper (Op1360, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cdai, 1, GN, SMB)
Oper (Op1368, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cdai, 1, GN, SMB)
Oper (Op1370, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cdai, 1, GN, SMB)
Oper (Op1378, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cdai, 1, GN, SMB)
Oper (Op1380, DoMoveB, DB, SdB, (inst & 7), DB, DA, Caix, 1, GN, SMB)
Oper (Op1390, DoMoveB, DB, SainB, (inst & 7), DB, DA, Caix, 1, GN, SMB)
Oper (Op1398, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Caix, 1, GN, SMB)
Oper (Op13a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Caix, 1, GN, SMB)
Oper (Op13a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Caix, 1, GN, SMB)
Oper (Op13b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Caix, 1, GN, SMB)
Oper (Op13b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Caix, 1, GN, SMB)
Oper (Op13c0, DoMoveB, DB, SdB, (inst & 7), DB, DA, Ceaw, 1, GN, SMB)
Oper (Op13d0, DoMoveB, DB, SainB, (inst & 7), DB, DA, Ceaw, 1, GN, SMB)
Oper (Op13d8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Ceaw, 1, GN, SMB)
Oper (Op13e0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Ceaw, 1, GN, SMB)
Oper (Op13e8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Ceaw, 1, GN, SMB)
Oper (Op13f0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Ceaw, 1, GN, SMB)
Oper (Op13f8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Ceaw, 1, GN, SMB)

Oper (Op1400, DoMoveB, DB, SdB, (inst & 7), DB, DR, Cd, 2, GN, SRB)
Oper (Op1410, DoMoveB, DB, SainB, (inst & 7), DB, DR, Cd, 2, GN, SRB)
Oper (Op1418, DoMoveB, DB, SaipB, (inst & 7), DB, DR, Cd, 2, GN, SRB)
Oper (Op1420, DoMoveB, DB, SmaiB, (inst & 7), DB, DR, Cd, 2, GN, SRB)
Oper (Op1428, DoMoveB, DB, SdaiB, (inst & 7), DB, DR, Cd, 2, GN, SRB)
Oper (Op1430, DoMoveB, DB, SaixB, (inst & 7), DB, DR, Cd, 2, GN, SRB)
Oper (Op1438, DoMoveB, DB, SearB, (inst & 7), DB, DR, Cd, 2, GN, SRB)
Oper (Op1480, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cain, 2, GN, SMB)
Oper (Op1490, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cain, 2, GN, SMB)
Oper (Op1498, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cain, 2, GN, SMB)
Oper (Op14a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cain, 2, GN, SMB)
Oper (Op14a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cain, 2, GN, SMB)
Oper (Op14b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cain, 2, GN, SMB)
Oper (Op14b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cain, 2, GN, SMB)
Oper (Op14c0, DoMoveB, DB, SdB, (inst & 7), DB, DA, CaipB, 2, GN, SMB)
Oper (Op14d0, DoMoveB, DB, SainB, (inst & 7), DB, DA, CaipB, 2, GN, SMB)
Oper (Op14d8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CaipB, 2, GN, SMB)
Oper (Op14e0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CaipB, 2, GN, SMB)
Oper (Op14e8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CaipB, 2, GN, SMB)
Oper (Op14f0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CaipB, 2, GN, SMB)
Oper (Op14f8, DoMoveB, DB, SearB, (inst & 7), DB, DA, CaipB, 2, GN, SMB)
Oper (Op1500, DoMoveB, DB, SdB, (inst & 7), DB, DA, CmaiB, 2, GN, SMB)
Oper (Op1510, DoMoveB, DB, SainB, (inst & 7), DB, DA, CmaiB, 2, GN, SMB)
Oper (Op1518, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CmaiB, 2, GN, SMB)
Oper (Op1520, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 2, GN, SMB)
Oper (Op1528, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CmaiB, 2, GN, SMB)
Oper (Op1530, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CmaiB, 2, GN, SMB)
Oper (Op1538, DoMoveB, DB, SearB, (inst & 7), DB, DA, CmaiB, 2, GN, SMB)
Oper (Op1540, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cdai, 2, GN, SMB)
Oper (Op1550, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cdai, 2, GN, SMB)
Oper (Op1558, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cdai, 2, GN, SMB)
Oper (Op1560, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cdai, 2, GN, SMB)
Oper (Op1568, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cdai, 2, GN, SMB)
Oper (Op1570, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cdai, 2, GN, SMB)
Oper (Op1578, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cdai, 2, GN, SMB)
Oper (Op1580, DoMoveB, DB, SdB, (inst & 7), DB, DA, Caix, 2, GN, SMB)
Oper (Op1590, DoMoveB, DB, SainB, (inst & 7), DB, DA, Caix, 2, GN, SMB)
Oper (Op1598, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Caix, 2, GN, SMB)
Oper (Op15a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Caix, 2, GN, SMB)
Oper (Op15a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Caix, 2, GN, SMB)
Oper (Op15b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Caix, 2, GN, SMB)
Oper (Op15b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Caix, 2, GN, SMB)

Oper (Op1600, DoMoveB, DB, SdB, (inst & 7), DB, DR, Cd, 3, GN, SRB)
Oper (Op1610, DoMoveB, DB, SainB, (inst & 7), DB, DR, Cd, 3, GN, SRB)
Oper (Op1618, DoMoveB, DB, SaipB, (inst & 7), DB, DR, Cd, 3, GN, SRB)
Oper (Op1620, DoMoveB, DB, SmaiB, (inst & 7), DB, DR, Cd, 3, GN, SRB)
Oper (Op1628, DoMoveB, DB, SdaiB, (inst & 7), DB, DR, Cd, 3, GN, SRB)
Oper (Op1630, DoMoveB, DB, SaixB, (inst & 7), DB, DR, Cd, 3, GN, SRB)
Oper (Op1638, DoMoveB, DB, SearB, (inst & 7), DB, DR, Cd, 3, GN, SRB)
Oper (Op1680, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cain, 3, GN, SMB)
Oper (Op1690, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cain, 3, GN, SMB)
Oper (Op1698, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cain, 3, GN, SMB)
Oper (Op16a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cain, 3, GN, SMB)
Oper (Op16a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cain, 3, GN, SMB)
Oper (Op16b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cain, 3, GN, SMB)
Oper (Op16b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cain, 3, GN, SMB)
Oper (Op16c0, DoMoveB, DB, SdB, (inst & 7), DB, DA, CaipB, 3, GN, SMB)
Oper (Op16d0, DoMoveB, DB, SainB, (inst & 7), DB, DA, CaipB, 3, GN, SMB)
Oper (Op16d8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CaipB, 3, GN, SMB)
Oper (Op16e0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CaipB, 3, GN, SMB)
Oper (Op16e8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CaipB, 3, GN, SMB)
Oper (Op16f0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CaipB, 3, GN, SMB)
Oper (Op16f8, DoMoveB, DB, SearB, (inst & 7), DB, DA, CaipB, 3, GN, SMB)
Oper (Op1700, DoMoveB, DB, SdB, (inst & 7), DB, DA, CmaiB, 3, GN, SMB)
Oper (Op1710, DoMoveB, DB, SainB, (inst & 7), DB, DA, CmaiB, 3, GN, SMB)
Oper (Op1718, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CmaiB, 3, GN, SMB)
Oper (Op1720, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 3, GN, SMB)
Oper (Op1728, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CmaiB, 3, GN, SMB)
Oper (Op1730, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CmaiB, 3, GN, SMB)
Oper (Op1738, DoMoveB, DB, SearB, (inst & 7), DB, DA, CmaiB, 3, GN, SMB)
Oper (Op1740, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cdai, 3, GN, SMB)
Oper (Op1750, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cdai, 3, GN, SMB)
Oper (Op1758, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cdai, 3, GN, SMB)
Oper (Op1760, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cdai, 3, GN, SMB)
Oper (Op1768, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cdai, 3, GN, SMB)
Oper (Op1770, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cdai, 3, GN, SMB)
Oper (Op1778, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cdai, 3, GN, SMB)
Oper (Op1780, DoMoveB, DB, SdB, (inst & 7), DB, DA, Caix, 3, GN, SMB)
Oper (Op1790, DoMoveB, DB, SainB, (inst & 7), DB, DA, Caix, 3, GN, SMB)
Oper (Op1798, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Caix, 3, GN, SMB)
Oper (Op17a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Caix, 3, GN, SMB)
Oper (Op17a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Caix, 3, GN, SMB)
Oper (Op17b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Caix, 3, GN, SMB)
Oper (Op17b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Caix, 3, GN, SMB)

Oper (Op1800, DoMoveB, DB, SdB, (inst & 7), DB, DR, Cd, 4, GN, SRB)
Oper (Op1810, DoMoveB, DB, SainB, (inst & 7), DB, DR, Cd, 4, GN, SRB)
Oper (Op1818, DoMoveB, DB, SaipB, (inst & 7), DB, DR, Cd, 4, GN, SRB)
Oper (Op1820, DoMoveB, DB, SmaiB, (inst & 7), DB, DR, Cd, 4, GN, SRB)
Oper (Op1828, DoMoveB, DB, SdaiB, (inst & 7), DB, DR, Cd, 4, GN, SRB)
Oper (Op1830, DoMoveB, DB, SaixB, (inst & 7), DB, DR, Cd, 4, GN, SRB)
Oper (Op1838, DoMoveB, DB, SearB, (inst & 7), DB, DR, Cd, 4, GN, SRB)
Oper (Op1880, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cain, 4, GN, SMB)
Oper (Op1890, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cain, 4, GN, SMB)
Oper (Op1898, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cain, 4, GN, SMB)
Oper (Op18a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cain, 4, GN, SMB)
Oper (Op18a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cain, 4, GN, SMB)
Oper (Op18b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cain, 4, GN, SMB)
Oper (Op18b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cain, 4, GN, SMB)
Oper (Op18c0, DoMoveB, DB, SdB, (inst & 7), DB, DA, CaipB, 4, GN, SMB)
Oper (Op18d0, DoMoveB, DB, SainB, (inst & 7), DB, DA, CaipB, 4, GN, SMB)
Oper (Op18d8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CaipB, 4, GN, SMB)
Oper (Op18e0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CaipB, 4, GN, SMB)
Oper (Op18e8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CaipB, 4, GN, SMB)
Oper (Op18f0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CaipB, 4, GN, SMB)
Oper (Op18f8, DoMoveB, DB, SearB, (inst & 7), DB, DA, CaipB, 4, GN, SMB)
Oper (Op1900, DoMoveB, DB, SdB, (inst & 7), DB, DA, CmaiB, 4, GN, SMB)
Oper (Op1910, DoMoveB, DB, SainB, (inst & 7), DB, DA, CmaiB, 4, GN, SMB)
Oper (Op1918, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CmaiB, 4, GN, SMB)
Oper (Op1920, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 4, GN, SMB)
Oper (Op1928, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CmaiB, 4, GN, SMB)
Oper (Op1930, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CmaiB, 4, GN, SMB)
Oper (Op1938, DoMoveB, DB, SearB, (inst & 7), DB, DA, CmaiB, 4, GN, SMB)
Oper (Op1940, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cdai, 4, GN, SMB)
Oper (Op1950, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cdai, 4, GN, SMB)
Oper (Op1958, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cdai, 4, GN, SMB)
Oper (Op1960, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cdai, 4, GN, SMB)
Oper (Op1968, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cdai, 4, GN, SMB)
Oper (Op1970, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cdai, 4, GN, SMB)
Oper (Op1978, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cdai, 4, GN, SMB)
Oper (Op1980, DoMoveB, DB, SdB, (inst & 7), DB, DA, Caix, 4, GN, SMB)
Oper (Op1990, DoMoveB, DB, SainB, (inst & 7), DB, DA, Caix, 4, GN, SMB)
Oper (Op1998, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Caix, 4, GN, SMB)
Oper (Op19a0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Caix, 4, GN, SMB)
Oper (Op19a8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Caix, 4, GN, SMB)
Oper (Op19b0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Caix, 4, GN, SMB)
Oper (Op19b8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Caix, 4, GN, SMB)

Oper (Op1a00, DoMoveB, DB, SdB, (inst & 7), DB, DR, Cd, 5, GN, SRB)
Oper (Op1a10, DoMoveB, DB, SainB, (inst & 7), DB, DR, Cd, 5, GN, SRB)
Oper (Op1a18, DoMoveB, DB, SaipB, (inst & 7), DB, DR, Cd, 5, GN, SRB)
Oper (Op1a20, DoMoveB, DB, SmaiB, (inst & 7), DB, DR, Cd, 5, GN, SRB)
Oper (Op1a28, DoMoveB, DB, SdaiB, (inst & 7), DB, DR, Cd, 5, GN, SRB)
Oper (Op1a30, DoMoveB, DB, SaixB, (inst & 7), DB, DR, Cd, 5, GN, SRB)
Oper (Op1a38, DoMoveB, DB, SearB, (inst & 7), DB, DR, Cd, 5, GN, SRB)
Oper (Op1a80, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cain, 5, GN, SMB)
Oper (Op1a90, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cain, 5, GN, SMB)
Oper (Op1a98, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cain, 5, GN, SMB)
Oper (Op1aa0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cain, 5, GN, SMB)
Oper (Op1aa8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cain, 5, GN, SMB)
Oper (Op1ab0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cain, 5, GN, SMB)
Oper (Op1ab8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cain, 5, GN, SMB)
Oper (Op1ac0, DoMoveB, DB, SdB, (inst & 7), DB, DA, CaipB, 5, GN, SMB)
Oper (Op1ad0, DoMoveB, DB, SainB, (inst & 7), DB, DA, CaipB, 5, GN, SMB)
Oper (Op1ad8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CaipB, 5, GN, SMB)
Oper (Op1ae0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CaipB, 5, GN, SMB)
Oper (Op1ae8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CaipB, 5, GN, SMB)
Oper (Op1af0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CaipB, 5, GN, SMB)
Oper (Op1af8, DoMoveB, DB, SearB, (inst & 7), DB, DA, CaipB, 5, GN, SMB)
Oper (Op1b00, DoMoveB, DB, SdB, (inst & 7), DB, DA, CmaiB, 5, GN, SMB)
Oper (Op1b10, DoMoveB, DB, SainB, (inst & 7), DB, DA, CmaiB, 5, GN, SMB)
Oper (Op1b18, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CmaiB, 5, GN, SMB)
Oper (Op1b20, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 5, GN, SMB)
Oper (Op1b28, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CmaiB, 5, GN, SMB)
Oper (Op1b30, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CmaiB, 5, GN, SMB)
Oper (Op1b38, DoMoveB, DB, SearB, (inst & 7), DB, DA, CmaiB, 5, GN, SMB)
Oper (Op1b40, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cdai, 5, GN, SMB)
Oper (Op1b50, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cdai, 5, GN, SMB)
Oper (Op1b58, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cdai, 5, GN, SMB)
Oper (Op1b60, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cdai, 5, GN, SMB)
Oper (Op1b68, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cdai, 5, GN, SMB)
Oper (Op1b70, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cdai, 5, GN, SMB)
Oper (Op1b78, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cdai, 5, GN, SMB)
Oper (Op1b80, DoMoveB, DB, SdB, (inst & 7), DB, DA, Caix, 5, GN, SMB)
Oper (Op1b90, DoMoveB, DB, SainB, (inst & 7), DB, DA, Caix, 5, GN, SMB)
Oper (Op1b98, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Caix, 5, GN, SMB)
Oper (Op1ba0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Caix, 5, GN, SMB)
Oper (Op1ba8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Caix, 5, GN, SMB)
Oper (Op1bb0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Caix, 5, GN, SMB)
Oper (Op1bb8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Caix, 5, GN, SMB)

Oper (Op1c00, DoMoveB, DB, SdB, (inst & 7), DB, DR, Cd, 6, GN, SRB)
Oper (Op1c10, DoMoveB, DB, SainB, (inst & 7), DB, DR, Cd, 6, GN, SRB)
Oper (Op1c18, DoMoveB, DB, SaipB, (inst & 7), DB, DR, Cd, 6, GN, SRB)
Oper (Op1c20, DoMoveB, DB, SmaiB, (inst & 7), DB, DR, Cd, 6, GN, SRB)
Oper (Op1c28, DoMoveB, DB, SdaiB, (inst & 7), DB, DR, Cd, 6, GN, SRB)
Oper (Op1c30, DoMoveB, DB, SaixB, (inst & 7), DB, DR, Cd, 6, GN, SRB)
Oper (Op1c38, DoMoveB, DB, SearB, (inst & 7), DB, DR, Cd, 6, GN, SRB)
Oper (Op1c80, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cain, 6, GN, SMB)
Oper (Op1c90, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cain, 6, GN, SMB)
Oper (Op1c98, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cain, 6, GN, SMB)
Oper (Op1ca0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cain, 6, GN, SMB)
Oper (Op1ca8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cain, 6, GN, SMB)
Oper (Op1cb0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cain, 6, GN, SMB)
Oper (Op1cb8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cain, 6, GN, SMB)
Oper (Op1cc0, DoMoveB, DB, SdB, (inst & 7), DB, DA, CaipB, 6, GN, SMB)
Oper (Op1cd0, DoMoveB, DB, SainB, (inst & 7), DB, DA, CaipB, 6, GN, SMB)
Oper (Op1cd8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CaipB, 6, GN, SMB)
Oper (Op1ce0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CaipB, 6, GN, SMB)
Oper (Op1ce8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CaipB, 6, GN, SMB)
Oper (Op1cf0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CaipB, 6, GN, SMB)
Oper (Op1cf8, DoMoveB, DB, SearB, (inst & 7), DB, DA, CaipB, 6, GN, SMB)
Oper (Op1d00, DoMoveB, DB, SdB, (inst & 7), DB, DA, CmaiB, 6, GN, SMB)
Oper (Op1d10, DoMoveB, DB, SainB, (inst & 7), DB, DA, CmaiB, 6, GN, SMB)
Oper (Op1d18, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CmaiB, 6, GN, SMB)
Oper (Op1d20, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 6, GN, SMB)
Oper (Op1d28, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CmaiB, 6, GN, SMB)
Oper (Op1d30, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CmaiB, 6, GN, SMB)
Oper (Op1d38, DoMoveB, DB, SearB, (inst & 7), DB, DA, CmaiB, 6, GN, SMB)
Oper (Op1d40, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cdai, 6, GN, SMB)
Oper (Op1d50, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cdai, 6, GN, SMB)
Oper (Op1d58, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cdai, 6, GN, SMB)
Oper (Op1d60, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cdai, 6, GN, SMB)
Oper (Op1d68, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cdai, 6, GN, SMB)
Oper (Op1d70, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cdai, 6, GN, SMB)
Oper (Op1d78, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cdai, 6, GN, SMB)
Oper (Op1d80, DoMoveB, DB, SdB, (inst & 7), DB, DA, Caix, 6, GN, SMB)
Oper (Op1d90, DoMoveB, DB, SainB, (inst & 7), DB, DA, Caix, 6, GN, SMB)
Oper (Op1d98, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Caix, 6, GN, SMB)
Oper (Op1da0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Caix, 6, GN, SMB)
Oper (Op1da8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Caix, 6, GN, SMB)
Oper (Op1db0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Caix, 6, GN, SMB)
Oper (Op1db8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Caix, 6, GN, SMB)

Oper (Op1e00, DoMoveB, DB, SdB, (inst & 7), DB, DR, Cd, 7, GN, SRB)
Oper (Op1e10, DoMoveB, DB, SainB, (inst & 7), DB, DR, Cd, 7, GN, SRB)
Oper (Op1e18, DoMoveB, DB, SaipB, (inst & 7), DB, DR, Cd, 7, GN, SRB)
Oper (Op1e20, DoMoveB, DB, SmaiB, (inst & 7), DB, DR, Cd, 7, GN, SRB)
Oper (Op1e28, DoMoveB, DB, SdaiB, (inst & 7), DB, DR, Cd, 7, GN, SRB)
Oper (Op1e30, DoMoveB, DB, SaixB, (inst & 7), DB, DR, Cd, 7, GN, SRB)
Oper (Op1e38, DoMoveB, DB, SearB, (inst & 7), DB, DR, Cd, 7, GN, SRB)
Oper (Op1e80, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cain, 7, GN, SMB)
Oper (Op1e90, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cain, 7, GN, SMB)
Oper (Op1e98, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cain, 7, GN, SMB)
Oper (Op1ea0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cain, 7, GN, SMB)
Oper (Op1ea8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cain, 7, GN, SMB)
Oper (Op1eb0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cain, 7, GN, SMB)
Oper (Op1eb8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cain, 7, GN, SMB)
Oper (Op1ec0, DoMoveB, DB, SdB, (inst & 7), DB, DA, CaipB15, 7, GN, SMB)
Oper (Op1ed0, DoMoveB, DB, SainB, (inst & 7), DB, DA, CaipB15, 7, GN, SMB)
Oper (Op1ed8, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CaipB15, 7, GN, SMB)
Oper (Op1ee0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CaipB15, 7, GN, SMB)
Oper (Op1ee8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CaipB15, 7, GN, SMB)
Oper (Op1ef0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CaipB15, 7, GN, SMB)
Oper (Op1ef8, DoMoveB, DB, SearB, (inst & 7), DB, DA, CaipB15, 7, GN, SMB)
Oper (Op1f00, DoMoveB, DB, SdB, (inst & 7), DB, DA, CmaiB15, 7, GN, SMB)
Oper (Op1f10, DoMoveB, DB, SainB, (inst & 7), DB, DA, CmaiB15, 7, GN, SMB)
Oper (Op1f18, DoMoveB, DB, SaipB, (inst & 7), DB, DA, CmaiB15, 7, GN, SMB)
Oper (Op1f20, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, CmaiB15, 7, GN, SMB)
Oper (Op1f28, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, CmaiB15, 7, GN, SMB)
Oper (Op1f30, DoMoveB, DB, SaixB, (inst & 7), DB, DA, CmaiB15, 7, GN, SMB)
Oper (Op1f38, DoMoveB, DB, SearB, (inst & 7), DB, DA, CmaiB15, 7, GN, SMB)
Oper (Op1f40, DoMoveB, DB, SdB, (inst & 7), DB, DA, Cdai, 7, GN, SMB)
Oper (Op1f50, DoMoveB, DB, SainB, (inst & 7), DB, DA, Cdai, 7, GN, SMB)
Oper (Op1f58, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Cdai, 7, GN, SMB)
Oper (Op1f60, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Cdai, 7, GN, SMB)
Oper (Op1f68, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Cdai, 7, GN, SMB)
Oper (Op1f70, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Cdai, 7, GN, SMB)
Oper (Op1f78, DoMoveB, DB, SearB, (inst & 7), DB, DA, Cdai, 7, GN, SMB)
Oper (Op1f80, DoMoveB, DB, SdB, (inst & 7), DB, DA, Caix, 7, GN, SMB)
Oper (Op1f90, DoMoveB, DB, SainB, (inst & 7), DB, DA, Caix, 7, GN, SMB)
Oper (Op1f98, DoMoveB, DB, SaipB, (inst & 7), DB, DA, Caix, 7, GN, SMB)
Oper (Op1fa0, DoMoveB, DB, SmaiB, (inst & 7), DB, DA, Caix, 7, GN, SMB)
Oper (Op1fa8, DoMoveB, DB, SdaiB, (inst & 7), DB, DA, Caix, 7, GN, SMB)
Oper (Op1fb0, DoMoveB, DB, SaixB, (inst & 7), DB, DA, Caix, 7, GN, SMB)
Oper (Op1fb8, DoMoveB, DB, SearB, (inst & 7), DB, DA, Caix, 7, GN, SMB)

Oper (Op2000, DoMoveL, DL, SdL, (inst & 7), DL, DR, Cd, 0, GN, SRL)
Oper (Op2008, DoMoveL, DL, SaL, (inst & 7), DL, DR, Cd, 0, GN, SRL)
Oper (Op2010, DoMoveL, DL, SainL, (inst & 7), DL, DR, Cd, 0, GN, SRL)
Oper (Op2018, DoMoveL, DL, SaipL, (inst & 7), DL, DR, Cd, 0, GN, SRL)
Oper (Op2020, DoMoveL, DL, SmaiL, (inst & 7), DL, DR, Cd, 0, GN, SRL)
Oper (Op2028, DoMoveL, DL, SdaiL, (inst & 7), DL, DR, Cd, 0, GN, SRL)
Oper (Op2030, DoMoveL, DL, SaixL, (inst & 7), DL, DR, Cd, 0, GN, SRL)
Oper (Op2038, DoMoveL, DL, SearL, (inst & 7), DL, DR, Cd, 0, GN, SRL)
Oper (Op2040, DoMovea, DL, SdL, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op2048, DoMovea, DL, SaL, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op2050, DoMovea, DL, SainL, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op2058, DoMovea, DL, SaipL, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op2060, DoMovea, DL, SmaiL, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op2068, DoMovea, DL, SdaiL, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op2070, DoMovea, DL, SaixL, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op2078, DoMovea, DL, SearL, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op2080, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cain, 0, GN, SML)
Oper (Op2088, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cain, 0, GN, SML)
Oper (Op2090, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cain, 0, GN, SML)
Oper (Op2098, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cain, 0, GN, SML)
Oper (Op20a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cain, 0, GN, SML)
Oper (Op20a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cain, 0, GN, SML)
Oper (Op20b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cain, 0, GN, SML)
Oper (Op20b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cain, 0, GN, SML)
Oper (Op20c0, DoMoveL, DL, SdL, (inst & 7), DL, DA, CaipL, 0, GN, SML)
Oper (Op20c8, DoMoveL, DL, SaL, (inst & 7), DL, DA, CaipL, 0, GN, SML)
Oper (Op20d0, DoMoveL, DL, SainL, (inst & 7), DL, DA, CaipL, 0, GN, SML)
Oper (Op20d8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CaipL, 0, GN, SML)
Oper (Op20e0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CaipL, 0, GN, SML)
Oper (Op20e8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CaipL, 0, GN, SML)
Oper (Op20f0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CaipL, 0, GN, SML)
Oper (Op20f8, DoMoveL, DL, SearL, (inst & 7), DL, DA, CaipL, 0, GN, SML)
Oper (Op2100, DoMoveL, DL, SdL, (inst & 7), DL, DA, CmaiL, 0, GN, SML)
Oper (Op2108, DoMoveL, DL, SaL, (inst & 7), DL, DA, CmaiL, 0, GN, SML)
Oper (Op2110, DoMoveL, DL, SainL, (inst & 7), DL, DA, CmaiL, 0, GN, SML)
Oper (Op2118, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CmaiL, 0, GN, SML)
Oper (Op2120, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 0, GN, SML)
Oper (Op2128, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CmaiL, 0, GN, SML)
Oper (Op2130, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CmaiL, 0, GN, SML)
Oper (Op2138, DoMoveL, DL, SearL, (inst & 7), DL, DA, CmaiL, 0, GN, SML)
Oper (Op2140, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cdai, 0, GN, SML)
Oper (Op2148, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cdai, 0, GN, SML)
Oper (Op2150, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cdai, 0, GN, SML)
Oper (Op2158, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cdai, 0, GN, SML)
Oper (Op2160, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cdai, 0, GN, SML)
Oper (Op2168, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cdai, 0, GN, SML)
Oper (Op2170, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cdai, 0, GN, SML)
Oper (Op2178, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cdai, 0, GN, SML)
Oper (Op2180, DoMoveL, DL, SdL, (inst & 7), DL, DA, Caix, 0, GN, SML)
Oper (Op2188, DoMoveL, DL, SaL, (inst & 7), DL, DA, Caix, 0, GN, SML)
Oper (Op2190, DoMoveL, DL, SainL, (inst & 7), DL, DA, Caix, 0, GN, SML)
Oper (Op2198, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Caix, 0, GN, SML)
Oper (Op21a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Caix, 0, GN, SML)
Oper (Op21a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Caix, 0, GN, SML)
Oper (Op21b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Caix, 0, GN, SML)
Oper (Op21b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Caix, 0, GN, SML)
Oper (Op21c0, DoMoveL, DL, SdL, (inst & 7), DL, DA, Ceaw, 0, GN, SML)
Oper (Op21c8, DoMoveL, DL, SaL, (inst & 7), DL, DA, Ceaw, 0, GN, SML)
Oper (Op21d0, DoMoveL, DL, SainL, (inst & 7), DL, DA, Ceaw, 0, GN, SML)
Oper (Op21d8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Ceaw, 0, GN, SML)
Oper (Op21e0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Ceaw, 0, GN, SML)
Oper (Op21e8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Ceaw, 0, GN, SML)
Oper (Op21f0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Ceaw, 0, GN, SML)
Oper (Op21f8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Ceaw, 0, GN, SML)

Oper (Op2200, DoMoveL, DL, SdL, (inst & 7), DL, DR, Cd, 1, GN, SRL)
Oper (Op2208, DoMoveL, DL, SaL, (inst & 7), DL, DR, Cd, 1, GN, SRL)
Oper (Op2210, DoMoveL, DL, SainL, (inst & 7), DL, DR, Cd, 1, GN, SRL)
Oper (Op2218, DoMoveL, DL, SaipL, (inst & 7), DL, DR, Cd, 1, GN, SRL)
Oper (Op2220, DoMoveL, DL, SmaiL, (inst & 7), DL, DR, Cd, 1, GN, SRL)
Oper (Op2228, DoMoveL, DL, SdaiL, (inst & 7), DL, DR, Cd, 1, GN, SRL)
Oper (Op2230, DoMoveL, DL, SaixL, (inst & 7), DL, DR, Cd, 1, GN, SRL)
Oper (Op2238, DoMoveL, DL, SearL, (inst & 7), DL, DR, Cd, 1, GN, SRL)
Oper (Op2240, DoMovea, DL, SdL, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op2248, DoMovea, DL, SaL, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op2250, DoMovea, DL, SainL, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op2258, DoMovea, DL, SaipL, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op2260, DoMovea, DL, SmaiL, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op2268, DoMovea, DL, SdaiL, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op2270, DoMovea, DL, SaixL, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op2278, DoMovea, DL, SearL, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op2280, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cain, 1, GN, SML)
Oper (Op2288, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cain, 1, GN, SML)
Oper (Op2290, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cain, 1, GN, SML)
Oper (Op2298, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cain, 1, GN, SML)
Oper (Op22a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cain, 1, GN, SML)
Oper (Op22a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cain, 1, GN, SML)
Oper (Op22b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cain, 1, GN, SML)
Oper (Op22b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cain, 1, GN, SML)
Oper (Op22c0, DoMoveL, DL, SdL, (inst & 7), DL, DA, CaipL, 1, GN, SML)
Oper (Op22c8, DoMoveL, DL, SaL, (inst & 7), DL, DA, CaipL, 1, GN, SML)
Oper (Op22d0, DoMoveL, DL, SainL, (inst & 7), DL, DA, CaipL, 1, GN, SML)
Oper (Op22d8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CaipL, 1, GN, SML)
Oper (Op22e0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CaipL, 1, GN, SML)
Oper (Op22e8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CaipL, 1, GN, SML)
Oper (Op22f0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CaipL, 1, GN, SML)
Oper (Op22f8, DoMoveL, DL, SearL, (inst & 7), DL, DA, CaipL, 1, GN, SML)
Oper (Op2300, DoMoveL, DL, SdL, (inst & 7), DL, DA, CmaiL, 1, GN, SML)
Oper (Op2308, DoMoveL, DL, SaL, (inst & 7), DL, DA, CmaiL, 1, GN, SML)
Oper (Op2310, DoMoveL, DL, SainL, (inst & 7), DL, DA, CmaiL, 1, GN, SML)
Oper (Op2318, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CmaiL, 1, GN, SML)
Oper (Op2320, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 1, GN, SML)
Oper (Op2328, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CmaiL, 1, GN, SML)
Oper (Op2330, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CmaiL, 1, GN, SML)
Oper (Op2338, DoMoveL, DL, SearL, (inst & 7), DL, DA, CmaiL, 1, GN, SML)
Oper (Op2340, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cdai, 1, GN, SML)
Oper (Op2348, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cdai, 1, GN, SML)
Oper (Op2350, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cdai, 1, GN, SML)
Oper (Op2358, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cdai, 1, GN, SML)
Oper (Op2360, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cdai, 1, GN, SML)
Oper (Op2368, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cdai, 1, GN, SML)
Oper (Op2370, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cdai, 1, GN, SML)
Oper (Op2378, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cdai, 1, GN, SML)
Oper (Op2380, DoMoveL, DL, SdL, (inst & 7), DL, DA, Caix, 1, GN, SML)
Oper (Op2388, DoMoveL, DL, SaL, (inst & 7), DL, DA, Caix, 1, GN, SML)
Oper (Op2390, DoMoveL, DL, SainL, (inst & 7), DL, DA, Caix, 1, GN, SML)
Oper (Op2398, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Caix, 1, GN, SML)
Oper (Op23a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Caix, 1, GN, SML)
Oper (Op23a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Caix, 1, GN, SML)
Oper (Op23b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Caix, 1, GN, SML)
Oper (Op23b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Caix, 1, GN, SML)
Oper (Op23c0, DoMoveL, DL, SdL, (inst & 7), DL, DA, Ceaw, 1, GN, SML)
Oper (Op23c8, DoMoveL, DL, SaL, (inst & 7), DL, DA, Ceaw, 1, GN, SML)
Oper (Op23d0, DoMoveL, DL, SainL, (inst & 7), DL, DA, Ceaw, 1, GN, SML)
Oper (Op23d8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Ceaw, 1, GN, SML)
Oper (Op23e0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Ceaw, 1, GN, SML)
Oper (Op23e8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Ceaw, 1, GN, SML)
Oper (Op23f0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Ceaw, 1, GN, SML)
Oper (Op23f8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Ceaw, 1, GN, SML)

Oper (Op2400, DoMoveL, DL, SdL, (inst & 7), DL, DR, Cd, 2, GN, SRL)
Oper (Op2408, DoMoveL, DL, SaL, (inst & 7), DL, DR, Cd, 2, GN, SRL)
Oper (Op2410, DoMoveL, DL, SainL, (inst & 7), DL, DR, Cd, 2, GN, SRL)
Oper (Op2418, DoMoveL, DL, SaipL, (inst & 7), DL, DR, Cd, 2, GN, SRL)
Oper (Op2420, DoMoveL, DL, SmaiL, (inst & 7), DL, DR, Cd, 2, GN, SRL)
Oper (Op2428, DoMoveL, DL, SdaiL, (inst & 7), DL, DR, Cd, 2, GN, SRL)
Oper (Op2430, DoMoveL, DL, SaixL, (inst & 7), DL, DR, Cd, 2, GN, SRL)
Oper (Op2438, DoMoveL, DL, SearL, (inst & 7), DL, DR, Cd, 2, GN, SRL)
Oper (Op2440, DoMovea, DL, SdL, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op2448, DoMovea, DL, SaL, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op2450, DoMovea, DL, SainL, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op2458, DoMovea, DL, SaipL, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op2460, DoMovea, DL, SmaiL, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op2468, DoMovea, DL, SdaiL, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op2470, DoMovea, DL, SaixL, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op2478, DoMovea, DL, SearL, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op2480, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cain, 2, GN, SML)
Oper (Op2488, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cain, 2, GN, SML)
Oper (Op2490, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cain, 2, GN, SML)
Oper (Op2498, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cain, 2, GN, SML)
Oper (Op24a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cain, 2, GN, SML)
Oper (Op24a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cain, 2, GN, SML)
Oper (Op24b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cain, 2, GN, SML)
Oper (Op24b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cain, 2, GN, SML)
Oper (Op24c0, DoMoveL, DL, SdL, (inst & 7), DL, DA, CaipL, 2, GN, SML)
Oper (Op24c8, DoMoveL, DL, SaL, (inst & 7), DL, DA, CaipL, 2, GN, SML)
Oper (Op24d0, DoMoveL, DL, SainL, (inst & 7), DL, DA, CaipL, 2, GN, SML)
Oper (Op24d8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CaipL, 2, GN, SML)
Oper (Op24e0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CaipL, 2, GN, SML)
Oper (Op24e8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CaipL, 2, GN, SML)
Oper (Op24f0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CaipL, 2, GN, SML)
Oper (Op24f8, DoMoveL, DL, SearL, (inst & 7), DL, DA, CaipL, 2, GN, SML)
Oper (Op2500, DoMoveL, DL, SdL, (inst & 7), DL, DA, CmaiL, 2, GN, SML)
Oper (Op2508, DoMoveL, DL, SaL, (inst & 7), DL, DA, CmaiL, 2, GN, SML)
Oper (Op2510, DoMoveL, DL, SainL, (inst & 7), DL, DA, CmaiL, 2, GN, SML)
Oper (Op2518, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CmaiL, 2, GN, SML)
Oper (Op2520, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 2, GN, SML)
Oper (Op2528, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CmaiL, 2, GN, SML)
Oper (Op2530, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CmaiL, 2, GN, SML)
Oper (Op2538, DoMoveL, DL, SearL, (inst & 7), DL, DA, CmaiL, 2, GN, SML)
Oper (Op2540, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cdai, 2, GN, SML)
Oper (Op2548, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cdai, 2, GN, SML)
Oper (Op2550, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cdai, 2, GN, SML)
Oper (Op2558, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cdai, 2, GN, SML)
Oper (Op2560, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cdai, 2, GN, SML)
Oper (Op2568, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cdai, 2, GN, SML)
Oper (Op2570, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cdai, 2, GN, SML)
Oper (Op2578, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cdai, 2, GN, SML)
Oper (Op2580, DoMoveL, DL, SdL, (inst & 7), DL, DA, Caix, 2, GN, SML)
Oper (Op2588, DoMoveL, DL, SaL, (inst & 7), DL, DA, Caix, 2, GN, SML)
Oper (Op2590, DoMoveL, DL, SainL, (inst & 7), DL, DA, Caix, 2, GN, SML)
Oper (Op2598, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Caix, 2, GN, SML)
Oper (Op25a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Caix, 2, GN, SML)
Oper (Op25a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Caix, 2, GN, SML)
Oper (Op25b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Caix, 2, GN, SML)
Oper (Op25b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Caix, 2, GN, SML)

Oper (Op2600, DoMoveL, DL, SdL, (inst & 7), DL, DR, Cd, 3, GN, SRL)
Oper (Op2608, DoMoveL, DL, SaL, (inst & 7), DL, DR, Cd, 3, GN, SRL)
Oper (Op2610, DoMoveL, DL, SainL, (inst & 7), DL, DR, Cd, 3, GN, SRL)
Oper (Op2618, DoMoveL, DL, SaipL, (inst & 7), DL, DR, Cd, 3, GN, SRL)
Oper (Op2620, DoMoveL, DL, SmaiL, (inst & 7), DL, DR, Cd, 3, GN, SRL)
Oper (Op2628, DoMoveL, DL, SdaiL, (inst & 7), DL, DR, Cd, 3, GN, SRL)
Oper (Op2630, DoMoveL, DL, SaixL, (inst & 7), DL, DR, Cd, 3, GN, SRL)
Oper (Op2638, DoMoveL, DL, SearL, (inst & 7), DL, DR, Cd, 3, GN, SRL)
Oper (Op2640, DoMovea, DL, SdL, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op2648, DoMovea, DL, SaL, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op2650, DoMovea, DL, SainL, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op2658, DoMovea, DL, SaipL, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op2660, DoMovea, DL, SmaiL, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op2668, DoMovea, DL, SdaiL, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op2670, DoMovea, DL, SaixL, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op2678, DoMovea, DL, SearL, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op2680, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cain, 3, GN, SML)
Oper (Op2688, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cain, 3, GN, SML)
Oper (Op2690, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cain, 3, GN, SML)
Oper (Op2698, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cain, 3, GN, SML)
Oper (Op26a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cain, 3, GN, SML)
Oper (Op26a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cain, 3, GN, SML)
Oper (Op26b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cain, 3, GN, SML)
Oper (Op26b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cain, 3, GN, SML)
Oper (Op26c0, DoMoveL, DL, SdL, (inst & 7), DL, DA, CaipL, 3, GN, SML)
Oper (Op26c8, DoMoveL, DL, SaL, (inst & 7), DL, DA, CaipL, 3, GN, SML)
Oper (Op26d0, DoMoveL, DL, SainL, (inst & 7), DL, DA, CaipL, 3, GN, SML)
Oper (Op26d8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CaipL, 3, GN, SML)
Oper (Op26e0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CaipL, 3, GN, SML)
Oper (Op26e8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CaipL, 3, GN, SML)
Oper (Op26f0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CaipL, 3, GN, SML)
Oper (Op26f8, DoMoveL, DL, SearL, (inst & 7), DL, DA, CaipL, 3, GN, SML)
Oper (Op2700, DoMoveL, DL, SdL, (inst & 7), DL, DA, CmaiL, 3, GN, SML)
Oper (Op2708, DoMoveL, DL, SaL, (inst & 7), DL, DA, CmaiL, 3, GN, SML)
Oper (Op2710, DoMoveL, DL, SainL, (inst & 7), DL, DA, CmaiL, 3, GN, SML)
Oper (Op2718, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CmaiL, 3, GN, SML)
Oper (Op2720, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 3, GN, SML)
Oper (Op2728, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CmaiL, 3, GN, SML)
Oper (Op2730, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CmaiL, 3, GN, SML)
Oper (Op2738, DoMoveL, DL, SearL, (inst & 7), DL, DA, CmaiL, 3, GN, SML)
Oper (Op2740, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cdai, 3, GN, SML)
Oper (Op2748, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cdai, 3, GN, SML)
Oper (Op2750, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cdai, 3, GN, SML)
Oper (Op2758, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cdai, 3, GN, SML)
Oper (Op2760, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cdai, 3, GN, SML)
Oper (Op2768, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cdai, 3, GN, SML)
Oper (Op2770, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cdai, 3, GN, SML)
Oper (Op2778, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cdai, 3, GN, SML)
Oper (Op2780, DoMoveL, DL, SdL, (inst & 7), DL, DA, Caix, 3, GN, SML)
Oper (Op2788, DoMoveL, DL, SaL, (inst & 7), DL, DA, Caix, 3, GN, SML)
Oper (Op2790, DoMoveL, DL, SainL, (inst & 7), DL, DA, Caix, 3, GN, SML)
Oper (Op2798, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Caix, 3, GN, SML)
Oper (Op27a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Caix, 3, GN, SML)
Oper (Op27a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Caix, 3, GN, SML)
Oper (Op27b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Caix, 3, GN, SML)
Oper (Op27b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Caix, 3, GN, SML)

Oper (Op2800, DoMoveL, DL, SdL, (inst & 7), DL, DR, Cd, 4, GN, SRL)
Oper (Op2808, DoMoveL, DL, SaL, (inst & 7), DL, DR, Cd, 4, GN, SRL)
Oper (Op2810, DoMoveL, DL, SainL, (inst & 7), DL, DR, Cd, 4, GN, SRL)
Oper (Op2818, DoMoveL, DL, SaipL, (inst & 7), DL, DR, Cd, 4, GN, SRL)
Oper (Op2820, DoMoveL, DL, SmaiL, (inst & 7), DL, DR, Cd, 4, GN, SRL)
Oper (Op2828, DoMoveL, DL, SdaiL, (inst & 7), DL, DR, Cd, 4, GN, SRL)
Oper (Op2830, DoMoveL, DL, SaixL, (inst & 7), DL, DR, Cd, 4, GN, SRL)
Oper (Op2838, DoMoveL, DL, SearL, (inst & 7), DL, DR, Cd, 4, GN, SRL)
Oper (Op2840, DoMovea, DL, SdL, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op2848, DoMovea, DL, SaL, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op2850, DoMovea, DL, SainL, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op2858, DoMovea, DL, SaipL, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op2860, DoMovea, DL, SmaiL, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op2868, DoMovea, DL, SdaiL, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op2870, DoMovea, DL, SaixL, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op2878, DoMovea, DL, SearL, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op2880, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cain, 4, GN, SML)
Oper (Op2888, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cain, 4, GN, SML)
Oper (Op2890, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cain, 4, GN, SML)
Oper (Op2898, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cain, 4, GN, SML)
Oper (Op28a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cain, 4, GN, SML)
Oper (Op28a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cain, 4, GN, SML)
Oper (Op28b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cain, 4, GN, SML)
Oper (Op28b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cain, 4, GN, SML)
Oper (Op28c0, DoMoveL, DL, SdL, (inst & 7), DL, DA, CaipL, 4, GN, SML)
Oper (Op28c8, DoMoveL, DL, SaL, (inst & 7), DL, DA, CaipL, 4, GN, SML)
Oper (Op28d0, DoMoveL, DL, SainL, (inst & 7), DL, DA, CaipL, 4, GN, SML)
Oper (Op28d8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CaipL, 4, GN, SML)
Oper (Op28e0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CaipL, 4, GN, SML)
Oper (Op28e8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CaipL, 4, GN, SML)
Oper (Op28f0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CaipL, 4, GN, SML)
Oper (Op28f8, DoMoveL, DL, SearL, (inst & 7), DL, DA, CaipL, 4, GN, SML)
Oper (Op2900, DoMoveL, DL, SdL, (inst & 7), DL, DA, CmaiL, 4, GN, SML)
Oper (Op2908, DoMoveL, DL, SaL, (inst & 7), DL, DA, CmaiL, 4, GN, SML)
Oper (Op2910, DoMoveL, DL, SainL, (inst & 7), DL, DA, CmaiL, 4, GN, SML)
Oper (Op2918, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CmaiL, 4, GN, SML)
Oper (Op2920, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 4, GN, SML)
Oper (Op2928, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CmaiL, 4, GN, SML)
Oper (Op2930, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CmaiL, 4, GN, SML)
Oper (Op2938, DoMoveL, DL, SearL, (inst & 7), DL, DA, CmaiL, 4, GN, SML)
Oper (Op2940, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cdai, 4, GN, SML)
Oper (Op2948, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cdai, 4, GN, SML)
Oper (Op2950, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cdai, 4, GN, SML)
Oper (Op2958, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cdai, 4, GN, SML)
Oper (Op2960, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cdai, 4, GN, SML)
Oper (Op2968, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cdai, 4, GN, SML)
Oper (Op2970, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cdai, 4, GN, SML)
Oper (Op2978, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cdai, 4, GN, SML)
Oper (Op2980, DoMoveL, DL, SdL, (inst & 7), DL, DA, Caix, 4, GN, SML)
Oper (Op2988, DoMoveL, DL, SaL, (inst & 7), DL, DA, Caix, 4, GN, SML)
Oper (Op2990, DoMoveL, DL, SainL, (inst & 7), DL, DA, Caix, 4, GN, SML)
Oper (Op2998, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Caix, 4, GN, SML)
Oper (Op29a0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Caix, 4, GN, SML)
Oper (Op29a8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Caix, 4, GN, SML)
Oper (Op29b0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Caix, 4, GN, SML)
Oper (Op29b8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Caix, 4, GN, SML)

Oper (Op2a00, DoMoveL, DL, SdL, (inst & 7), DL, DR, Cd, 5, GN, SRL)
Oper (Op2a08, DoMoveL, DL, SaL, (inst & 7), DL, DR, Cd, 5, GN, SRL)
Oper (Op2a10, DoMoveL, DL, SainL, (inst & 7), DL, DR, Cd, 5, GN, SRL)
Oper (Op2a18, DoMoveL, DL, SaipL, (inst & 7), DL, DR, Cd, 5, GN, SRL)
Oper (Op2a20, DoMoveL, DL, SmaiL, (inst & 7), DL, DR, Cd, 5, GN, SRL)
Oper (Op2a28, DoMoveL, DL, SdaiL, (inst & 7), DL, DR, Cd, 5, GN, SRL)
Oper (Op2a30, DoMoveL, DL, SaixL, (inst & 7), DL, DR, Cd, 5, GN, SRL)
Oper (Op2a38, DoMoveL, DL, SearL, (inst & 7), DL, DR, Cd, 5, GN, SRL)
Oper (Op2a40, DoMovea, DL, SdL, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op2a48, DoMovea, DL, SaL, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op2a50, DoMovea, DL, SainL, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op2a58, DoMovea, DL, SaipL, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op2a60, DoMovea, DL, SmaiL, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op2a68, DoMovea, DL, SdaiL, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op2a70, DoMovea, DL, SaixL, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op2a78, DoMovea, DL, SearL, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op2a80, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cain, 5, GN, SML)
Oper (Op2a88, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cain, 5, GN, SML)
Oper (Op2a90, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cain, 5, GN, SML)
Oper (Op2a98, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cain, 5, GN, SML)
Oper (Op2aa0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cain, 5, GN, SML)
Oper (Op2aa8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cain, 5, GN, SML)
Oper (Op2ab0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cain, 5, GN, SML)
Oper (Op2ab8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cain, 5, GN, SML)
Oper (Op2ac0, DoMoveL, DL, SdL, (inst & 7), DL, DA, CaipL, 5, GN, SML)
Oper (Op2ac8, DoMoveL, DL, SaL, (inst & 7), DL, DA, CaipL, 5, GN, SML)
Oper (Op2ad0, DoMoveL, DL, SainL, (inst & 7), DL, DA, CaipL, 5, GN, SML)
Oper (Op2ad8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CaipL, 5, GN, SML)
Oper (Op2ae0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CaipL, 5, GN, SML)
Oper (Op2ae8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CaipL, 5, GN, SML)
Oper (Op2af0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CaipL, 5, GN, SML)
Oper (Op2af8, DoMoveL, DL, SearL, (inst & 7), DL, DA, CaipL, 5, GN, SML)
Oper (Op2b00, DoMoveL, DL, SdL, (inst & 7), DL, DA, CmaiL, 5, GN, SML)
Oper (Op2b08, DoMoveL, DL, SaL, (inst & 7), DL, DA, CmaiL, 5, GN, SML)
Oper (Op2b10, DoMoveL, DL, SainL, (inst & 7), DL, DA, CmaiL, 5, GN, SML)
Oper (Op2b18, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CmaiL, 5, GN, SML)
Oper (Op2b20, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 5, GN, SML)
Oper (Op2b28, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CmaiL, 5, GN, SML)
Oper (Op2b30, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CmaiL, 5, GN, SML)
Oper (Op2b38, DoMoveL, DL, SearL, (inst & 7), DL, DA, CmaiL, 5, GN, SML)
Oper (Op2b40, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cdai, 5, GN, SML)
Oper (Op2b48, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cdai, 5, GN, SML)
Oper (Op2b50, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cdai, 5, GN, SML)
Oper (Op2b58, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cdai, 5, GN, SML)
Oper (Op2b60, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cdai, 5, GN, SML)
Oper (Op2b68, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cdai, 5, GN, SML)
Oper (Op2b70, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cdai, 5, GN, SML)
Oper (Op2b78, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cdai, 5, GN, SML)
Oper (Op2b80, DoMoveL, DL, SdL, (inst & 7), DL, DA, Caix, 5, GN, SML)
Oper (Op2b88, DoMoveL, DL, SaL, (inst & 7), DL, DA, Caix, 5, GN, SML)
Oper (Op2b90, DoMoveL, DL, SainL, (inst & 7), DL, DA, Caix, 5, GN, SML)
Oper (Op2b98, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Caix, 5, GN, SML)
Oper (Op2ba0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Caix, 5, GN, SML)
Oper (Op2ba8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Caix, 5, GN, SML)
Oper (Op2bb0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Caix, 5, GN, SML)
Oper (Op2bb8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Caix, 5, GN, SML)

Oper (Op2c00, DoMoveL, DL, SdL, (inst & 7), DL, DR, Cd, 6, GN, SRL)
Oper (Op2c08, DoMoveL, DL, SaL, (inst & 7), DL, DR, Cd, 6, GN, SRL)
Oper (Op2c10, DoMoveL, DL, SainL, (inst & 7), DL, DR, Cd, 6, GN, SRL)
Oper (Op2c18, DoMoveL, DL, SaipL, (inst & 7), DL, DR, Cd, 6, GN, SRL)
Oper (Op2c20, DoMoveL, DL, SmaiL, (inst & 7), DL, DR, Cd, 6, GN, SRL)
Oper (Op2c28, DoMoveL, DL, SdaiL, (inst & 7), DL, DR, Cd, 6, GN, SRL)
Oper (Op2c30, DoMoveL, DL, SaixL, (inst & 7), DL, DR, Cd, 6, GN, SRL)
Oper (Op2c38, DoMoveL, DL, SearL, (inst & 7), DL, DR, Cd, 6, GN, SRL)
Oper (Op2c40, DoMovea, DL, SdL, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op2c48, DoMovea, DL, SaL, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op2c50, DoMovea, DL, SainL, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op2c58, DoMovea, DL, SaipL, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op2c60, DoMovea, DL, SmaiL, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op2c68, DoMovea, DL, SdaiL, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op2c70, DoMovea, DL, SaixL, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op2c78, DoMovea, DL, SearL, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op2c80, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cain, 6, GN, SML)
Oper (Op2c88, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cain, 6, GN, SML)
Oper (Op2c90, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cain, 6, GN, SML)
Oper (Op2c98, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cain, 6, GN, SML)
Oper (Op2ca0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cain, 6, GN, SML)
Oper (Op2ca8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cain, 6, GN, SML)
Oper (Op2cb0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cain, 6, GN, SML)
Oper (Op2cb8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cain, 6, GN, SML)
Oper (Op2cc0, DoMoveL, DL, SdL, (inst & 7), DL, DA, CaipL, 6, GN, SML)
Oper (Op2cc8, DoMoveL, DL, SaL, (inst & 7), DL, DA, CaipL, 6, GN, SML)
Oper (Op2cd0, DoMoveL, DL, SainL, (inst & 7), DL, DA, CaipL, 6, GN, SML)
Oper (Op2cd8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CaipL, 6, GN, SML)
Oper (Op2ce0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CaipL, 6, GN, SML)
Oper (Op2ce8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CaipL, 6, GN, SML)
Oper (Op2cf0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CaipL, 6, GN, SML)
Oper (Op2cf8, DoMoveL, DL, SearL, (inst & 7), DL, DA, CaipL, 6, GN, SML)
Oper (Op2d00, DoMoveL, DL, SdL, (inst & 7), DL, DA, CmaiL, 6, GN, SML)
Oper (Op2d08, DoMoveL, DL, SaL, (inst & 7), DL, DA, CmaiL, 6, GN, SML)
Oper (Op2d10, DoMoveL, DL, SainL, (inst & 7), DL, DA, CmaiL, 6, GN, SML)
Oper (Op2d18, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CmaiL, 6, GN, SML)
Oper (Op2d20, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 6, GN, SML)
Oper (Op2d28, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CmaiL, 6, GN, SML)
Oper (Op2d30, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CmaiL, 6, GN, SML)
Oper (Op2d38, DoMoveL, DL, SearL, (inst & 7), DL, DA, CmaiL, 6, GN, SML)
Oper (Op2d40, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cdai, 6, GN, SML)
Oper (Op2d48, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cdai, 6, GN, SML)
Oper (Op2d50, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cdai, 6, GN, SML)
Oper (Op2d58, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cdai, 6, GN, SML)
Oper (Op2d60, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cdai, 6, GN, SML)
Oper (Op2d68, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cdai, 6, GN, SML)
Oper (Op2d70, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cdai, 6, GN, SML)
Oper (Op2d78, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cdai, 6, GN, SML)
Oper (Op2d80, DoMoveL, DL, SdL, (inst & 7), DL, DA, Caix, 6, GN, SML)
Oper (Op2d88, DoMoveL, DL, SaL, (inst & 7), DL, DA, Caix, 6, GN, SML)
Oper (Op2d90, DoMoveL, DL, SainL, (inst & 7), DL, DA, Caix, 6, GN, SML)
Oper (Op2d98, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Caix, 6, GN, SML)
Oper (Op2da0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Caix, 6, GN, SML)
Oper (Op2da8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Caix, 6, GN, SML)
Oper (Op2db0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Caix, 6, GN, SML)
Oper (Op2db8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Caix, 6, GN, SML)

Oper (Op2e00, DoMoveL, DL, SdL, (inst & 7), DL, DR, Cd, 7, GN, SRL)
Oper (Op2e08, DoMoveL, DL, SaL, (inst & 7), DL, DR, Cd, 7, GN, SRL)
Oper (Op2e10, DoMoveL, DL, SainL, (inst & 7), DL, DR, Cd, 7, GN, SRL)
Oper (Op2e18, DoMoveL, DL, SaipL, (inst & 7), DL, DR, Cd, 7, GN, SRL)
Oper (Op2e20, DoMoveL, DL, SmaiL, (inst & 7), DL, DR, Cd, 7, GN, SRL)
Oper (Op2e28, DoMoveL, DL, SdaiL, (inst & 7), DL, DR, Cd, 7, GN, SRL)
Oper (Op2e30, DoMoveL, DL, SaixL, (inst & 7), DL, DR, Cd, 7, GN, SRL)
Oper (Op2e38, DoMoveL, DL, SearL, (inst & 7), DL, DR, Cd, 7, GN, SRL)
Oper (Op2e40, DoMovea, DL, SdL, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op2e48, DoMovea, DL, SaL, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op2e50, DoMovea, DL, SainL, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op2e58, DoMovea, DL, SaipL, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op2e60, DoMovea, DL, SmaiL, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op2e68, DoMovea, DL, SdaiL, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op2e70, DoMovea, DL, SaixL, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op2e78, DoMovea, DL, SearL, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op2e80, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cain, 7, GN, SML)
Oper (Op2e88, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cain, 7, GN, SML)
Oper (Op2e90, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cain, 7, GN, SML)
Oper (Op2e98, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cain, 7, GN, SML)
Oper (Op2ea0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cain, 7, GN, SML)
Oper (Op2ea8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cain, 7, GN, SML)
Oper (Op2eb0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cain, 7, GN, SML)
Oper (Op2eb8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cain, 7, GN, SML)
Oper (Op2ec0, DoMoveL, DL, SdL, (inst & 7), DL, DA, CaipL, 7, GN, SML)
Oper (Op2ec8, DoMoveL, DL, SaL, (inst & 7), DL, DA, CaipL, 7, GN, SML)
Oper (Op2ed0, DoMoveL, DL, SainL, (inst & 7), DL, DA, CaipL, 7, GN, SML)
Oper (Op2ed8, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CaipL, 7, GN, SML)
Oper (Op2ee0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CaipL, 7, GN, SML)
Oper (Op2ee8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CaipL, 7, GN, SML)
Oper (Op2ef0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CaipL, 7, GN, SML)
Oper (Op2ef8, DoMoveL, DL, SearL, (inst & 7), DL, DA, CaipL, 7, GN, SML)
Oper (Op2f00, DoMoveL, DL, SdL, (inst & 7), DL, DA, CmaiL, 7, GN, SML)
Oper (Op2f08, DoMoveL, DL, SaL, (inst & 7), DL, DA, CmaiL, 7, GN, SML)
Oper (Op2f10, DoMoveL, DL, SainL, (inst & 7), DL, DA, CmaiL, 7, GN, SML)
Oper (Op2f18, DoMoveL, DL, SaipL, (inst & 7), DL, DA, CmaiL, 7, GN, SML)
Oper (Op2f20, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 7, GN, SML)
Oper (Op2f28, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, CmaiL, 7, GN, SML)
Oper (Op2f30, DoMoveL, DL, SaixL, (inst & 7), DL, DA, CmaiL, 7, GN, SML)
Oper (Op2f38, DoMoveL, DL, SearL, (inst & 7), DL, DA, CmaiL, 7, GN, SML)
Oper (Op2f40, DoMoveL, DL, SdL, (inst & 7), DL, DA, Cdai, 7, GN, SML)
Oper (Op2f48, DoMoveL, DL, SaL, (inst & 7), DL, DA, Cdai, 7, GN, SML)
Oper (Op2f50, DoMoveL, DL, SainL, (inst & 7), DL, DA, Cdai, 7, GN, SML)
Oper (Op2f58, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Cdai, 7, GN, SML)
Oper (Op2f60, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Cdai, 7, GN, SML)
Oper (Op2f68, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Cdai, 7, GN, SML)
Oper (Op2f70, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Cdai, 7, GN, SML)
Oper (Op2f78, DoMoveL, DL, SearL, (inst & 7), DL, DA, Cdai, 7, GN, SML)
Oper (Op2f80, DoMoveL, DL, SdL, (inst & 7), DL, DA, Caix, 7, GN, SML)
Oper (Op2f88, DoMoveL, DL, SaL, (inst & 7), DL, DA, Caix, 7, GN, SML)
Oper (Op2f90, DoMoveL, DL, SainL, (inst & 7), DL, DA, Caix, 7, GN, SML)
Oper (Op2f98, DoMoveL, DL, SaipL, (inst & 7), DL, DA, Caix, 7, GN, SML)
Oper (Op2fa0, DoMoveL, DL, SmaiL, (inst & 7), DL, DA, Caix, 7, GN, SML)
Oper (Op2fa8, DoMoveL, DL, SdaiL, (inst & 7), DL, DA, Caix, 7, GN, SML)
Oper (Op2fb0, DoMoveL, DL, SaixL, (inst & 7), DL, DA, Caix, 7, GN, SML)
Oper (Op2fb8, DoMoveL, DL, SearL, (inst & 7), DL, DA, Caix, 7, GN, SML)

Oper (Op3000, DoMoveW, DW, SdW, (inst & 7), DW, DR, Cd, 0, GN, SRW)
Oper (Op3008, DoMoveW, DW, SaW, (inst & 7), DW, DR, Cd, 0, GN, SRW)
Oper (Op3010, DoMoveW, DW, SainW, (inst & 7), DW, DR, Cd, 0, GN, SRW)
Oper (Op3018, DoMoveW, DW, SaipW, (inst & 7), DW, DR, Cd, 0, GN, SRW)
Oper (Op3020, DoMoveW, DW, SmaiW, (inst & 7), DW, DR, Cd, 0, GN, SRW)
Oper (Op3028, DoMoveW, DW, SdaiW, (inst & 7), DW, DR, Cd, 0, GN, SRW)
Oper (Op3030, DoMoveW, DW, SaixW, (inst & 7), DW, DR, Cd, 0, GN, SRW)
Oper (Op3038, DoMoveW, DW, SearW, (inst & 7), DW, DR, Cd, 0, GN, SRW)
Oper (Op3040, DoMovea, DW, SdW, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op3048, DoMovea, DW, SaW, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op3050, DoMovea, DW, SainW, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op3058, DoMovea, DW, SaipW, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op3060, DoMovea, DW, SmaiW, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op3068, DoMovea, DW, SdaiW, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op3070, DoMovea, DW, SaixW, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op3078, DoMovea, DW, SearW, (inst & 7), DL, DR, Ca, 0, GN, SRL)
Oper (Op3080, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cain, 0, GN, SMW)
Oper (Op3088, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cain, 0, GN, SMW)
Oper (Op3090, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cain, 0, GN, SMW)
Oper (Op3098, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cain, 0, GN, SMW)
Oper (Op30a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cain, 0, GN, SMW)
Oper (Op30a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cain, 0, GN, SMW)
Oper (Op30b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cain, 0, GN, SMW)
Oper (Op30b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cain, 0, GN, SMW)
Oper (Op30c0, DoMoveW, DW, SdW, (inst & 7), DW, DA, CaipW, 0, GN, SMW)
Oper (Op30c8, DoMoveW, DW, SaW, (inst & 7), DW, DA, CaipW, 0, GN, SMW)
Oper (Op30d0, DoMoveW, DW, SainW, (inst & 7), DW, DA, CaipW, 0, GN, SMW)
Oper (Op30d8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CaipW, 0, GN, SMW)
Oper (Op30e0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CaipW, 0, GN, SMW)
Oper (Op30e8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CaipW, 0, GN, SMW)
Oper (Op30f0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CaipW, 0, GN, SMW)
Oper (Op30f8, DoMoveW, DW, SearW, (inst & 7), DW, DA, CaipW, 0, GN, SMW)
Oper (Op3100, DoMoveW, DW, SdW, (inst & 7), DW, DA, CmaiW, 0, GN, SMW)
Oper (Op3108, DoMoveW, DW, SaW, (inst & 7), DW, DA, CmaiW, 0, GN, SMW)
Oper (Op3110, DoMoveW, DW, SainW, (inst & 7), DW, DA, CmaiW, 0, GN, SMW)
Oper (Op3118, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CmaiW, 0, GN, SMW)
Oper (Op3120, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 0, GN, SMW)
Oper (Op3128, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CmaiW, 0, GN, SMW)
Oper (Op3130, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CmaiW, 0, GN, SMW)
Oper (Op3138, DoMoveW, DW, SearW, (inst & 7), DW, DA, CmaiW, 0, GN, SMW)
Oper (Op3140, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cdai, 0, GN, SMW)
Oper (Op3148, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cdai, 0, GN, SMW)
Oper (Op3150, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cdai, 0, GN, SMW)
Oper (Op3158, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cdai, 0, GN, SMW)
Oper (Op3160, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cdai, 0, GN, SMW)
Oper (Op3168, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cdai, 0, GN, SMW)
Oper (Op3170, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cdai, 0, GN, SMW)
Oper (Op3178, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cdai, 0, GN, SMW)
Oper (Op3180, DoMoveW, DW, SdW, (inst & 7), DW, DA, Caix, 0, GN, SMW)
Oper (Op3188, DoMoveW, DW, SaW, (inst & 7), DW, DA, Caix, 0, GN, SMW)
Oper (Op3190, DoMoveW, DW, SainW, (inst & 7), DW, DA, Caix, 0, GN, SMW)
Oper (Op3198, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Caix, 0, GN, SMW)
Oper (Op31a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Caix, 0, GN, SMW)
Oper (Op31a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Caix, 0, GN, SMW)
Oper (Op31b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Caix, 0, GN, SMW)
Oper (Op31b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Caix, 0, GN, SMW)
Oper (Op31c0, DoMoveW, DW, SdW, (inst & 7), DW, DA, Ceaw, 0, GN, SMW)
Oper (Op31c8, DoMoveW, DW, SaW, (inst & 7), DW, DA, Ceaw, 0, GN, SMW)
Oper (Op31d0, DoMoveW, DW, SainW, (inst & 7), DW, DA, Ceaw, 0, GN, SMW)
Oper (Op31d8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Ceaw, 0, GN, SMW)
Oper (Op31e0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Ceaw, 0, GN, SMW)
Oper (Op31e8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Ceaw, 0, GN, SMW)
Oper (Op31f0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Ceaw, 0, GN, SMW)
Oper (Op31f8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Ceaw, 0, GN, SMW)

Oper (Op3200, DoMoveW, DW, SdW, (inst & 7), DW, DR, Cd, 1, GN, SRW)
Oper (Op3208, DoMoveW, DW, SaW, (inst & 7), DW, DR, Cd, 1, GN, SRW)
Oper (Op3210, DoMoveW, DW, SainW, (inst & 7), DW, DR, Cd, 1, GN, SRW)
Oper (Op3218, DoMoveW, DW, SaipW, (inst & 7), DW, DR, Cd, 1, GN, SRW)
Oper (Op3220, DoMoveW, DW, SmaiW, (inst & 7), DW, DR, Cd, 1, GN, SRW)
Oper (Op3228, DoMoveW, DW, SdaiW, (inst & 7), DW, DR, Cd, 1, GN, SRW)
Oper (Op3230, DoMoveW, DW, SaixW, (inst & 7), DW, DR, Cd, 1, GN, SRW)
Oper (Op3238, DoMoveW, DW, SearW, (inst & 7), DW, DR, Cd, 1, GN, SRW)
Oper (Op3240, DoMovea, DW, SdW, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op3248, DoMovea, DW, SaW, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op3250, DoMovea, DW, SainW, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op3258, DoMovea, DW, SaipW, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op3260, DoMovea, DW, SmaiW, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op3268, DoMovea, DW, SdaiW, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op3270, DoMovea, DW, SaixW, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op3278, DoMovea, DW, SearW, (inst & 7), DL, DR, Ca, 1, GN, SRL)
Oper (Op3280, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cain, 1, GN, SMW)
Oper (Op3288, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cain, 1, GN, SMW)
Oper (Op3290, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cain, 1, GN, SMW)
Oper (Op3298, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cain, 1, GN, SMW)
Oper (Op32a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cain, 1, GN, SMW)
Oper (Op32a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cain, 1, GN, SMW)
Oper (Op32b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cain, 1, GN, SMW)
Oper (Op32b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cain, 1, GN, SMW)
Oper (Op32c0, DoMoveW, DW, SdW, (inst & 7), DW, DA, CaipW, 1, GN, SMW)
Oper (Op32c8, DoMoveW, DW, SaW, (inst & 7), DW, DA, CaipW, 1, GN, SMW)
Oper (Op32d0, DoMoveW, DW, SainW, (inst & 7), DW, DA, CaipW, 1, GN, SMW)
Oper (Op32d8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CaipW, 1, GN, SMW)
Oper (Op32e0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CaipW, 1, GN, SMW)
Oper (Op32e8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CaipW, 1, GN, SMW)
Oper (Op32f0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CaipW, 1, GN, SMW)
Oper (Op32f8, DoMoveW, DW, SearW, (inst & 7), DW, DA, CaipW, 1, GN, SMW)
Oper (Op3300, DoMoveW, DW, SdW, (inst & 7), DW, DA, CmaiW, 1, GN, SMW)
Oper (Op3308, DoMoveW, DW, SaW, (inst & 7), DW, DA, CmaiW, 1, GN, SMW)
Oper (Op3310, DoMoveW, DW, SainW, (inst & 7), DW, DA, CmaiW, 1, GN, SMW)
Oper (Op3318, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CmaiW, 1, GN, SMW)
Oper (Op3320, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 1, GN, SMW)
Oper (Op3328, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CmaiW, 1, GN, SMW)
Oper (Op3330, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CmaiW, 1, GN, SMW)
Oper (Op3338, DoMoveW, DW, SearW, (inst & 7), DW, DA, CmaiW, 1, GN, SMW)
Oper (Op3340, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cdai, 1, GN, SMW)
Oper (Op3348, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cdai, 1, GN, SMW)
Oper (Op3350, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cdai, 1, GN, SMW)
Oper (Op3358, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cdai, 1, GN, SMW)
Oper (Op3360, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cdai, 1, GN, SMW)
Oper (Op3368, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cdai, 1, GN, SMW)
Oper (Op3370, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cdai, 1, GN, SMW)
Oper (Op3378, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cdai, 1, GN, SMW)
Oper (Op3380, DoMoveW, DW, SdW, (inst & 7), DW, DA, Caix, 1, GN, SMW)
Oper (Op3388, DoMoveW, DW, SaW, (inst & 7), DW, DA, Caix, 1, GN, SMW)
Oper (Op3390, DoMoveW, DW, SainW, (inst & 7), DW, DA, Caix, 1, GN, SMW)
Oper (Op3398, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Caix, 1, GN, SMW)
Oper (Op33a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Caix, 1, GN, SMW)
Oper (Op33a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Caix, 1, GN, SMW)
Oper (Op33b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Caix, 1, GN, SMW)
Oper (Op33b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Caix, 1, GN, SMW)
Oper (Op33c0, DoMoveW, DW, SdW, (inst & 7), DW, DA, Ceaw, 1, GN, SMW)
Oper (Op33c8, DoMoveW, DW, SaW, (inst & 7), DW, DA, Ceaw, 1, GN, SMW)
Oper (Op33d0, DoMoveW, DW, SainW, (inst & 7), DW, DA, Ceaw, 1, GN, SMW)
Oper (Op33d8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Ceaw, 1, GN, SMW)
Oper (Op33e0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Ceaw, 1, GN, SMW)
Oper (Op33e8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Ceaw, 1, GN, SMW)
Oper (Op33f0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Ceaw, 1, GN, SMW)
Oper (Op33f8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Ceaw, 1, GN, SMW)

Oper (Op3400, DoMoveW, DW, SdW, (inst & 7), DW, DR, Cd, 2, GN, SRW)
Oper (Op3408, DoMoveW, DW, SaW, (inst & 7), DW, DR, Cd, 2, GN, SRW)
Oper (Op3410, DoMoveW, DW, SainW, (inst & 7), DW, DR, Cd, 2, GN, SRW)
Oper (Op3418, DoMoveW, DW, SaipW, (inst & 7), DW, DR, Cd, 2, GN, SRW)
Oper (Op3420, DoMoveW, DW, SmaiW, (inst & 7), DW, DR, Cd, 2, GN, SRW)
Oper (Op3428, DoMoveW, DW, SdaiW, (inst & 7), DW, DR, Cd, 2, GN, SRW)
Oper (Op3430, DoMoveW, DW, SaixW, (inst & 7), DW, DR, Cd, 2, GN, SRW)
Oper (Op3438, DoMoveW, DW, SearW, (inst & 7), DW, DR, Cd, 2, GN, SRW)
Oper (Op3440, DoMovea, DW, SdW, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op3448, DoMovea, DW, SaW, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op3450, DoMovea, DW, SainW, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op3458, DoMovea, DW, SaipW, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op3460, DoMovea, DW, SmaiW, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op3468, DoMovea, DW, SdaiW, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op3470, DoMovea, DW, SaixW, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op3478, DoMovea, DW, SearW, (inst & 7), DL, DR, Ca, 2, GN, SRL)
Oper (Op3480, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cain, 2, GN, SMW)
Oper (Op3488, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cain, 2, GN, SMW)
Oper (Op3490, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cain, 2, GN, SMW)
Oper (Op3498, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cain, 2, GN, SMW)
Oper (Op34a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cain, 2, GN, SMW)
Oper (Op34a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cain, 2, GN, SMW)
Oper (Op34b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cain, 2, GN, SMW)
Oper (Op34b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cain, 2, GN, SMW)
Oper (Op34c0, DoMoveW, DW, SdW, (inst & 7), DW, DA, CaipW, 2, GN, SMW)
Oper (Op34c8, DoMoveW, DW, SaW, (inst & 7), DW, DA, CaipW, 2, GN, SMW)
Oper (Op34d0, DoMoveW, DW, SainW, (inst & 7), DW, DA, CaipW, 2, GN, SMW)
Oper (Op34d8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CaipW, 2, GN, SMW)
Oper (Op34e0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CaipW, 2, GN, SMW)
Oper (Op34e8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CaipW, 2, GN, SMW)
Oper (Op34f0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CaipW, 2, GN, SMW)
Oper (Op34f8, DoMoveW, DW, SearW, (inst & 7), DW, DA, CaipW, 2, GN, SMW)
Oper (Op3500, DoMoveW, DW, SdW, (inst & 7), DW, DA, CmaiW, 2, GN, SMW)
Oper (Op3508, DoMoveW, DW, SaW, (inst & 7), DW, DA, CmaiW, 2, GN, SMW)
Oper (Op3510, DoMoveW, DW, SainW, (inst & 7), DW, DA, CmaiW, 2, GN, SMW)
Oper (Op3518, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CmaiW, 2, GN, SMW)
Oper (Op3520, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 2, GN, SMW)
Oper (Op3528, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CmaiW, 2, GN, SMW)
Oper (Op3530, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CmaiW, 2, GN, SMW)
Oper (Op3538, DoMoveW, DW, SearW, (inst & 7), DW, DA, CmaiW, 2, GN, SMW)
Oper (Op3540, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cdai, 2, GN, SMW)
Oper (Op3548, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cdai, 2, GN, SMW)
Oper (Op3550, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cdai, 2, GN, SMW)
Oper (Op3558, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cdai, 2, GN, SMW)
Oper (Op3560, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cdai, 2, GN, SMW)
Oper (Op3568, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cdai, 2, GN, SMW)
Oper (Op3570, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cdai, 2, GN, SMW)
Oper (Op3578, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cdai, 2, GN, SMW)
Oper (Op3580, DoMoveW, DW, SdW, (inst & 7), DW, DA, Caix, 2, GN, SMW)
Oper (Op3588, DoMoveW, DW, SaW, (inst & 7), DW, DA, Caix, 2, GN, SMW)
Oper (Op3590, DoMoveW, DW, SainW, (inst & 7), DW, DA, Caix, 2, GN, SMW)
Oper (Op3598, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Caix, 2, GN, SMW)
Oper (Op35a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Caix, 2, GN, SMW)
Oper (Op35a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Caix, 2, GN, SMW)
Oper (Op35b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Caix, 2, GN, SMW)
Oper (Op35b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Caix, 2, GN, SMW)

Oper (Op3600, DoMoveW, DW, SdW, (inst & 7), DW, DR, Cd, 3, GN, SRW)
Oper (Op3608, DoMoveW, DW, SaW, (inst & 7), DW, DR, Cd, 3, GN, SRW)
Oper (Op3610, DoMoveW, DW, SainW, (inst & 7), DW, DR, Cd, 3, GN, SRW)
Oper (Op3618, DoMoveW, DW, SaipW, (inst & 7), DW, DR, Cd, 3, GN, SRW)
Oper (Op3620, DoMoveW, DW, SmaiW, (inst & 7), DW, DR, Cd, 3, GN, SRW)
Oper (Op3628, DoMoveW, DW, SdaiW, (inst & 7), DW, DR, Cd, 3, GN, SRW)
Oper (Op3630, DoMoveW, DW, SaixW, (inst & 7), DW, DR, Cd, 3, GN, SRW)
Oper (Op3638, DoMoveW, DW, SearW, (inst & 7), DW, DR, Cd, 3, GN, SRW)
Oper (Op3640, DoMovea, DW, SdW, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op3648, DoMovea, DW, SaW, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op3650, DoMovea, DW, SainW, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op3658, DoMovea, DW, SaipW, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op3660, DoMovea, DW, SmaiW, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op3668, DoMovea, DW, SdaiW, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op3670, DoMovea, DW, SaixW, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op3678, DoMovea, DW, SearW, (inst & 7), DL, DR, Ca, 3, GN, SRL)
Oper (Op3680, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cain, 3, GN, SMW)
Oper (Op3688, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cain, 3, GN, SMW)
Oper (Op3690, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cain, 3, GN, SMW)
Oper (Op3698, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cain, 3, GN, SMW)
Oper (Op36a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cain, 3, GN, SMW)
Oper (Op36a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cain, 3, GN, SMW)
Oper (Op36b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cain, 3, GN, SMW)
Oper (Op36b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cain, 3, GN, SMW)
Oper (Op36c0, DoMoveW, DW, SdW, (inst & 7), DW, DA, CaipW, 3, GN, SMW)
Oper (Op36c8, DoMoveW, DW, SaW, (inst & 7), DW, DA, CaipW, 3, GN, SMW)
Oper (Op36d0, DoMoveW, DW, SainW, (inst & 7), DW, DA, CaipW, 3, GN, SMW)
Oper (Op36d8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CaipW, 3, GN, SMW)
Oper (Op36e0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CaipW, 3, GN, SMW)
Oper (Op36e8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CaipW, 3, GN, SMW)
Oper (Op36f0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CaipW, 3, GN, SMW)
Oper (Op36f8, DoMoveW, DW, SearW, (inst & 7), DW, DA, CaipW, 3, GN, SMW)
Oper (Op3700, DoMoveW, DW, SdW, (inst & 7), DW, DA, CmaiW, 3, GN, SMW)
Oper (Op3708, DoMoveW, DW, SaW, (inst & 7), DW, DA, CmaiW, 3, GN, SMW)
Oper (Op3710, DoMoveW, DW, SainW, (inst & 7), DW, DA, CmaiW, 3, GN, SMW)
Oper (Op3718, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CmaiW, 3, GN, SMW)
Oper (Op3720, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 3, GN, SMW)
Oper (Op3728, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CmaiW, 3, GN, SMW)
Oper (Op3730, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CmaiW, 3, GN, SMW)
Oper (Op3738, DoMoveW, DW, SearW, (inst & 7), DW, DA, CmaiW, 3, GN, SMW)
Oper (Op3740, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cdai, 3, GN, SMW)
Oper (Op3748, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cdai, 3, GN, SMW)
Oper (Op3750, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cdai, 3, GN, SMW)
Oper (Op3758, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cdai, 3, GN, SMW)
Oper (Op3760, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cdai, 3, GN, SMW)
Oper (Op3768, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cdai, 3, GN, SMW)
Oper (Op3770, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cdai, 3, GN, SMW)
Oper (Op3778, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cdai, 3, GN, SMW)
Oper (Op3780, DoMoveW, DW, SdW, (inst & 7), DW, DA, Caix, 3, GN, SMW)
Oper (Op3788, DoMoveW, DW, SaW, (inst & 7), DW, DA, Caix, 3, GN, SMW)
Oper (Op3790, DoMoveW, DW, SainW, (inst & 7), DW, DA, Caix, 3, GN, SMW)
Oper (Op3798, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Caix, 3, GN, SMW)
Oper (Op37a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Caix, 3, GN, SMW)
Oper (Op37a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Caix, 3, GN, SMW)
Oper (Op37b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Caix, 3, GN, SMW)
Oper (Op37b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Caix, 3, GN, SMW)

Oper (Op3800, DoMoveW, DW, SdW, (inst & 7), DW, DR, Cd, 4, GN, SRW)
Oper (Op3808, DoMoveW, DW, SaW, (inst & 7), DW, DR, Cd, 4, GN, SRW)
Oper (Op3810, DoMoveW, DW, SainW, (inst & 7), DW, DR, Cd, 4, GN, SRW)
Oper (Op3818, DoMoveW, DW, SaipW, (inst & 7), DW, DR, Cd, 4, GN, SRW)
Oper (Op3820, DoMoveW, DW, SmaiW, (inst & 7), DW, DR, Cd, 4, GN, SRW)
Oper (Op3828, DoMoveW, DW, SdaiW, (inst & 7), DW, DR, Cd, 4, GN, SRW)
Oper (Op3830, DoMoveW, DW, SaixW, (inst & 7), DW, DR, Cd, 4, GN, SRW)
Oper (Op3838, DoMoveW, DW, SearW, (inst & 7), DW, DR, Cd, 4, GN, SRW)
Oper (Op3840, DoMovea, DW, SdW, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op3848, DoMovea, DW, SaW, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op3850, DoMovea, DW, SainW, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op3858, DoMovea, DW, SaipW, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op3860, DoMovea, DW, SmaiW, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op3868, DoMovea, DW, SdaiW, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op3870, DoMovea, DW, SaixW, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op3878, DoMovea, DW, SearW, (inst & 7), DL, DR, Ca, 4, GN, SRL)
Oper (Op3880, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cain, 4, GN, SMW)
Oper (Op3888, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cain, 4, GN, SMW)
Oper (Op3890, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cain, 4, GN, SMW)
Oper (Op3898, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cain, 4, GN, SMW)
Oper (Op38a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cain, 4, GN, SMW)
Oper (Op38a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cain, 4, GN, SMW)
Oper (Op38b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cain, 4, GN, SMW)
Oper (Op38b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cain, 4, GN, SMW)
Oper (Op38c0, DoMoveW, DW, SdW, (inst & 7), DW, DA, CaipW, 4, GN, SMW)
Oper (Op38c8, DoMoveW, DW, SaW, (inst & 7), DW, DA, CaipW, 4, GN, SMW)
Oper (Op38d0, DoMoveW, DW, SainW, (inst & 7), DW, DA, CaipW, 4, GN, SMW)
Oper (Op38d8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CaipW, 4, GN, SMW)
Oper (Op38e0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CaipW, 4, GN, SMW)
Oper (Op38e8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CaipW, 4, GN, SMW)
Oper (Op38f0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CaipW, 4, GN, SMW)
Oper (Op38f8, DoMoveW, DW, SearW, (inst & 7), DW, DA, CaipW, 4, GN, SMW)
Oper (Op3900, DoMoveW, DW, SdW, (inst & 7), DW, DA, CmaiW, 4, GN, SMW)
Oper (Op3908, DoMoveW, DW, SaW, (inst & 7), DW, DA, CmaiW, 4, GN, SMW)
Oper (Op3910, DoMoveW, DW, SainW, (inst & 7), DW, DA, CmaiW, 4, GN, SMW)
Oper (Op3918, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CmaiW, 4, GN, SMW)
Oper (Op3920, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 4, GN, SMW)
Oper (Op3928, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CmaiW, 4, GN, SMW)
Oper (Op3930, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CmaiW, 4, GN, SMW)
Oper (Op3938, DoMoveW, DW, SearW, (inst & 7), DW, DA, CmaiW, 4, GN, SMW)
Oper (Op3940, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cdai, 4, GN, SMW)
Oper (Op3948, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cdai, 4, GN, SMW)
Oper (Op3950, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cdai, 4, GN, SMW)
Oper (Op3958, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cdai, 4, GN, SMW)
Oper (Op3960, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cdai, 4, GN, SMW)
Oper (Op3968, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cdai, 4, GN, SMW)
Oper (Op3970, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cdai, 4, GN, SMW)
Oper (Op3978, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cdai, 4, GN, SMW)
Oper (Op3980, DoMoveW, DW, SdW, (inst & 7), DW, DA, Caix, 4, GN, SMW)
Oper (Op3988, DoMoveW, DW, SaW, (inst & 7), DW, DA, Caix, 4, GN, SMW)
Oper (Op3990, DoMoveW, DW, SainW, (inst & 7), DW, DA, Caix, 4, GN, SMW)
Oper (Op3998, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Caix, 4, GN, SMW)
Oper (Op39a0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Caix, 4, GN, SMW)
Oper (Op39a8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Caix, 4, GN, SMW)
Oper (Op39b0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Caix, 4, GN, SMW)
Oper (Op39b8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Caix, 4, GN, SMW)

Oper (Op3a00, DoMoveW, DW, SdW, (inst & 7), DW, DR, Cd, 5, GN, SRW)
Oper (Op3a08, DoMoveW, DW, SaW, (inst & 7), DW, DR, Cd, 5, GN, SRW)
Oper (Op3a10, DoMoveW, DW, SainW, (inst & 7), DW, DR, Cd, 5, GN, SRW)
Oper (Op3a18, DoMoveW, DW, SaipW, (inst & 7), DW, DR, Cd, 5, GN, SRW)
Oper (Op3a20, DoMoveW, DW, SmaiW, (inst & 7), DW, DR, Cd, 5, GN, SRW)
Oper (Op3a28, DoMoveW, DW, SdaiW, (inst & 7), DW, DR, Cd, 5, GN, SRW)
Oper (Op3a30, DoMoveW, DW, SaixW, (inst & 7), DW, DR, Cd, 5, GN, SRW)
Oper (Op3a38, DoMoveW, DW, SearW, (inst & 7), DW, DR, Cd, 5, GN, SRW)
Oper (Op3a40, DoMovea, DW, SdW, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op3a48, DoMovea, DW, SaW, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op3a50, DoMovea, DW, SainW, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op3a58, DoMovea, DW, SaipW, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op3a60, DoMovea, DW, SmaiW, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op3a68, DoMovea, DW, SdaiW, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op3a70, DoMovea, DW, SaixW, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op3a78, DoMovea, DW, SearW, (inst & 7), DL, DR, Ca, 5, GN, SRL)
Oper (Op3a80, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cain, 5, GN, SMW)
Oper (Op3a88, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cain, 5, GN, SMW)
Oper (Op3a90, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cain, 5, GN, SMW)
Oper (Op3a98, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cain, 5, GN, SMW)
Oper (Op3aa0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cain, 5, GN, SMW)
Oper (Op3aa8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cain, 5, GN, SMW)
Oper (Op3ab0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cain, 5, GN, SMW)
Oper (Op3ab8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cain, 5, GN, SMW)
Oper (Op3ac0, DoMoveW, DW, SdW, (inst & 7), DW, DA, CaipW, 5, GN, SMW)
Oper (Op3ac8, DoMoveW, DW, SaW, (inst & 7), DW, DA, CaipW, 5, GN, SMW)
Oper (Op3ad0, DoMoveW, DW, SainW, (inst & 7), DW, DA, CaipW, 5, GN, SMW)
Oper (Op3ad8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CaipW, 5, GN, SMW)
Oper (Op3ae0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CaipW, 5, GN, SMW)
Oper (Op3ae8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CaipW, 5, GN, SMW)
Oper (Op3af0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CaipW, 5, GN, SMW)
Oper (Op3af8, DoMoveW, DW, SearW, (inst & 7), DW, DA, CaipW, 5, GN, SMW)
Oper (Op3b00, DoMoveW, DW, SdW, (inst & 7), DW, DA, CmaiW, 5, GN, SMW)
Oper (Op3b08, DoMoveW, DW, SaW, (inst & 7), DW, DA, CmaiW, 5, GN, SMW)
Oper (Op3b10, DoMoveW, DW, SainW, (inst & 7), DW, DA, CmaiW, 5, GN, SMW)
Oper (Op3b18, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CmaiW, 5, GN, SMW)
Oper (Op3b20, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 5, GN, SMW)
Oper (Op3b28, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CmaiW, 5, GN, SMW)
Oper (Op3b30, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CmaiW, 5, GN, SMW)
Oper (Op3b38, DoMoveW, DW, SearW, (inst & 7), DW, DA, CmaiW, 5, GN, SMW)
Oper (Op3b40, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cdai, 5, GN, SMW)
Oper (Op3b48, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cdai, 5, GN, SMW)
Oper (Op3b50, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cdai, 5, GN, SMW)
Oper (Op3b58, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cdai, 5, GN, SMW)
Oper (Op3b60, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cdai, 5, GN, SMW)
Oper (Op3b68, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cdai, 5, GN, SMW)
Oper (Op3b70, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cdai, 5, GN, SMW)
Oper (Op3b78, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cdai, 5, GN, SMW)
Oper (Op3b80, DoMoveW, DW, SdW, (inst & 7), DW, DA, Caix, 5, GN, SMW)
Oper (Op3b88, DoMoveW, DW, SaW, (inst & 7), DW, DA, Caix, 5, GN, SMW)
Oper (Op3b90, DoMoveW, DW, SainW, (inst & 7), DW, DA, Caix, 5, GN, SMW)
Oper (Op3b98, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Caix, 5, GN, SMW)
Oper (Op3ba0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Caix, 5, GN, SMW)
Oper (Op3ba8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Caix, 5, GN, SMW)
Oper (Op3bb0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Caix, 5, GN, SMW)
Oper (Op3bb8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Caix, 5, GN, SMW)

Oper (Op3c00, DoMoveW, DW, SdW, (inst & 7), DW, DR, Cd, 6, GN, SRW)
Oper (Op3c08, DoMoveW, DW, SaW, (inst & 7), DW, DR, Cd, 6, GN, SRW)
Oper (Op3c10, DoMoveW, DW, SainW, (inst & 7), DW, DR, Cd, 6, GN, SRW)
Oper (Op3c18, DoMoveW, DW, SaipW, (inst & 7), DW, DR, Cd, 6, GN, SRW)
Oper (Op3c20, DoMoveW, DW, SmaiW, (inst & 7), DW, DR, Cd, 6, GN, SRW)
Oper (Op3c28, DoMoveW, DW, SdaiW, (inst & 7), DW, DR, Cd, 6, GN, SRW)
Oper (Op3c30, DoMoveW, DW, SaixW, (inst & 7), DW, DR, Cd, 6, GN, SRW)
Oper (Op3c38, DoMoveW, DW, SearW, (inst & 7), DW, DR, Cd, 6, GN, SRW)
Oper (Op3c40, DoMovea, DW, SdW, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op3c48, DoMovea, DW, SaW, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op3c50, DoMovea, DW, SainW, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op3c58, DoMovea, DW, SaipW, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op3c60, DoMovea, DW, SmaiW, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op3c68, DoMovea, DW, SdaiW, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op3c70, DoMovea, DW, SaixW, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op3c78, DoMovea, DW, SearW, (inst & 7), DL, DR, Ca, 6, GN, SRL)
Oper (Op3c80, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cain, 6, GN, SMW)
Oper (Op3c88, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cain, 6, GN, SMW)
Oper (Op3c90, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cain, 6, GN, SMW)
Oper (Op3c98, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cain, 6, GN, SMW)
Oper (Op3ca0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cain, 6, GN, SMW)
Oper (Op3ca8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cain, 6, GN, SMW)
Oper (Op3cb0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cain, 6, GN, SMW)
Oper (Op3cb8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cain, 6, GN, SMW)
Oper (Op3cc0, DoMoveW, DW, SdW, (inst & 7), DW, DA, CaipW, 6, GN, SMW)
Oper (Op3cc8, DoMoveW, DW, SaW, (inst & 7), DW, DA, CaipW, 6, GN, SMW)
Oper (Op3cd0, DoMoveW, DW, SainW, (inst & 7), DW, DA, CaipW, 6, GN, SMW)
Oper (Op3cd8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CaipW, 6, GN, SMW)
Oper (Op3ce0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CaipW, 6, GN, SMW)
Oper (Op3ce8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CaipW, 6, GN, SMW)
Oper (Op3cf0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CaipW, 6, GN, SMW)
Oper (Op3cf8, DoMoveW, DW, SearW, (inst & 7), DW, DA, CaipW, 6, GN, SMW)
Oper (Op3d00, DoMoveW, DW, SdW, (inst & 7), DW, DA, CmaiW, 6, GN, SMW)
Oper (Op3d08, DoMoveW, DW, SaW, (inst & 7), DW, DA, CmaiW, 6, GN, SMW)
Oper (Op3d10, DoMoveW, DW, SainW, (inst & 7), DW, DA, CmaiW, 6, GN, SMW)
Oper (Op3d18, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CmaiW, 6, GN, SMW)
Oper (Op3d20, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 6, GN, SMW)
Oper (Op3d28, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CmaiW, 6, GN, SMW)
Oper (Op3d30, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CmaiW, 6, GN, SMW)
Oper (Op3d38, DoMoveW, DW, SearW, (inst & 7), DW, DA, CmaiW, 6, GN, SMW)
Oper (Op3d40, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cdai, 6, GN, SMW)
Oper (Op3d48, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cdai, 6, GN, SMW)
Oper (Op3d50, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cdai, 6, GN, SMW)
Oper (Op3d58, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cdai, 6, GN, SMW)
Oper (Op3d60, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cdai, 6, GN, SMW)
Oper (Op3d68, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cdai, 6, GN, SMW)
Oper (Op3d70, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cdai, 6, GN, SMW)
Oper (Op3d78, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cdai, 6, GN, SMW)
Oper (Op3d80, DoMoveW, DW, SdW, (inst & 7), DW, DA, Caix, 6, GN, SMW)
Oper (Op3d88, DoMoveW, DW, SaW, (inst & 7), DW, DA, Caix, 6, GN, SMW)
Oper (Op3d90, DoMoveW, DW, SainW, (inst & 7), DW, DA, Caix, 6, GN, SMW)
Oper (Op3d98, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Caix, 6, GN, SMW)
Oper (Op3da0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Caix, 6, GN, SMW)
Oper (Op3da8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Caix, 6, GN, SMW)
Oper (Op3db0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Caix, 6, GN, SMW)
Oper (Op3db8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Caix, 6, GN, SMW)

Oper (Op3e00, DoMoveW, DW, SdW, (inst & 7), DW, DR, Cd, 7, GN, SRW)
Oper (Op3e08, DoMoveW, DW, SaW, (inst & 7), DW, DR, Cd, 7, GN, SRW)
Oper (Op3e10, DoMoveW, DW, SainW, (inst & 7), DW, DR, Cd, 7, GN, SRW)
Oper (Op3e18, DoMoveW, DW, SaipW, (inst & 7), DW, DR, Cd, 7, GN, SRW)
Oper (Op3e20, DoMoveW, DW, SmaiW, (inst & 7), DW, DR, Cd, 7, GN, SRW)
Oper (Op3e28, DoMoveW, DW, SdaiW, (inst & 7), DW, DR, Cd, 7, GN, SRW)
Oper (Op3e30, DoMoveW, DW, SaixW, (inst & 7), DW, DR, Cd, 7, GN, SRW)
Oper (Op3e38, DoMoveW, DW, SearW, (inst & 7), DW, DR, Cd, 7, GN, SRW)
Oper (Op3e40, DoMovea, DW, SdW, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op3e48, DoMovea, DW, SaW, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op3e50, DoMovea, DW, SainW, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op3e58, DoMovea, DW, SaipW, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op3e60, DoMovea, DW, SmaiW, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op3e68, DoMovea, DW, SdaiW, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op3e70, DoMovea, DW, SaixW, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op3e78, DoMovea, DW, SearW, (inst & 7), DL, DR, Ca, 7, GN, SRL)
Oper (Op3e80, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cain, 7, GN, SMW)
Oper (Op3e88, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cain, 7, GN, SMW)
Oper (Op3e90, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cain, 7, GN, SMW)
Oper (Op3e98, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cain, 7, GN, SMW)
Oper (Op3ea0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cain, 7, GN, SMW)
Oper (Op3ea8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cain, 7, GN, SMW)
Oper (Op3eb0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cain, 7, GN, SMW)
Oper (Op3eb8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cain, 7, GN, SMW)
Oper (Op3ec0, DoMoveW, DW, SdW, (inst & 7), DW, DA, CaipW, 7, GN, SMW)
Oper (Op3ec8, DoMoveW, DW, SaW, (inst & 7), DW, DA, CaipW, 7, GN, SMW)
Oper (Op3ed0, DoMoveW, DW, SainW, (inst & 7), DW, DA, CaipW, 7, GN, SMW)
Oper (Op3ed8, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CaipW, 7, GN, SMW)
Oper (Op3ee0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CaipW, 7, GN, SMW)
Oper (Op3ee8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CaipW, 7, GN, SMW)
Oper (Op3ef0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CaipW, 7, GN, SMW)
Oper (Op3ef8, DoMoveW, DW, SearW, (inst & 7), DW, DA, CaipW, 7, GN, SMW)
Oper (Op3f00, DoMoveW, DW, SdW, (inst & 7), DW, DA, CmaiW, 7, GN, SMW)
Oper (Op3f08, DoMoveW, DW, SaW, (inst & 7), DW, DA, CmaiW, 7, GN, SMW)
Oper (Op3f10, DoMoveW, DW, SainW, (inst & 7), DW, DA, CmaiW, 7, GN, SMW)
Oper (Op3f18, DoMoveW, DW, SaipW, (inst & 7), DW, DA, CmaiW, 7, GN, SMW)
Oper (Op3f20, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 7, GN, SMW)
Oper (Op3f28, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, CmaiW, 7, GN, SMW)
Oper (Op3f30, DoMoveW, DW, SaixW, (inst & 7), DW, DA, CmaiW, 7, GN, SMW)
Oper (Op3f38, DoMoveW, DW, SearW, (inst & 7), DW, DA, CmaiW, 7, GN, SMW)
Oper (Op3f40, DoMoveW, DW, SdW, (inst & 7), DW, DA, Cdai, 7, GN, SMW)
Oper (Op3f48, DoMoveW, DW, SaW, (inst & 7), DW, DA, Cdai, 7, GN, SMW)
Oper (Op3f50, DoMoveW, DW, SainW, (inst & 7), DW, DA, Cdai, 7, GN, SMW)
Oper (Op3f58, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Cdai, 7, GN, SMW)
Oper (Op3f60, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Cdai, 7, GN, SMW)
Oper (Op3f68, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Cdai, 7, GN, SMW)
Oper (Op3f70, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Cdai, 7, GN, SMW)
Oper (Op3f78, DoMoveW, DW, SearW, (inst & 7), DW, DA, Cdai, 7, GN, SMW)
Oper (Op3f80, DoMoveW, DW, SdW, (inst & 7), DW, DA, Caix, 7, GN, SMW)
Oper (Op3f88, DoMoveW, DW, SaW, (inst & 7), DW, DA, Caix, 7, GN, SMW)
Oper (Op3f90, DoMoveW, DW, SainW, (inst & 7), DW, DA, Caix, 7, GN, SMW)
Oper (Op3f98, DoMoveW, DW, SaipW, (inst & 7), DW, DA, Caix, 7, GN, SMW)
Oper (Op3fa0, DoMoveW, DW, SmaiW, (inst & 7), DW, DA, Caix, 7, GN, SMW)
Oper (Op3fa8, DoMoveW, DW, SdaiW, (inst & 7), DW, DA, Caix, 7, GN, SMW)
Oper (Op3fb0, DoMoveW, DW, SaixW, (inst & 7), DW, DA, Caix, 7, GN, SMW)
Oper (Op3fb8, DoMoveW, DW, SearW, (inst & 7), DW, DA, Caix, 7, GN, SMW)

Oper (Op7000, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 0, GN, SRL)
Oper (Op7200, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 1, GN, SRL)
Oper (Op7400, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 2, GN, SRL)
Oper (Op7600, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 3, GN, SRL)
Oper (Op7800, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 4, GN, SRL)
Oper (Op7a00, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 5, GN, SRL)
Oper (Op7c00, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 6, GN, SRL)
Oper (Op7e00, DoMoveL, DL, SNQ, 0, DL, DR, Cd, 7, GN, SRL)
